# Uruchom PowerShell jako administrator!

# Pokaż ukryte (nieaktywne) porty COM
$env:devmgr_show_nonpresent_devices = "1"

# Pobierz nieaktywne porty COM
$ghostPorts = Get-PnpDevice -PresentOnly:$false |
    Where-Object {
        $_.Class -eq "Ports" -and
        $_.Status -eq "Unknown" -and
        $_.FriendlyName -match "COM\d+"
    }

if ($ghostPorts.Count -eq 0) {
    Write-Host "❌ Nie znaleziono żadnych nieaktywnych portów COM."
    return
}

Write-Host "`n🔍 Znalezione nieaktywne porty COM:`n"
$i = 1
$ghostPorts | ForEach-Object {
    Write-Host "[$i] $($_.FriendlyName)"
    $i++
}

# Zapytaj użytkownika o działanie
$selection = Read-Host "`nWpisz numery portów do usunięcia (np. 1,2) lub 'all', aby usunąć wszystkie. Enter = anuluj"

if ([string]::IsNullOrWhiteSpace($selection)) {
    Write-Host "`n❎ Operacja anulowana."
    return
}

$toDelete = @()
if ($selection.Trim().ToLower() -eq "all") {
    $toDelete = $ghostPorts
} else {
    $indexes = $selection -split "," | ForEach-Object { $_.Trim() } | Where-Object { $_ -match '^\d+$' }
    foreach ($idx in $indexes) {
        $i = [int]$idx - 1
        if ($i -ge 0 -and $i -lt $ghostPorts.Count) {
            $toDelete += $ghostPorts[$i]
        } else {
            Write-Host "⚠️ Nieprawidłowy numer: $idx"
        }
    }
}

foreach ($device in $toDelete) {
    Write-Host "`n🗑️ Próba odinstalowania: $($device.FriendlyName)"
    try {
        # Znajdź identyfikator urządzenia
        $instanceId = $device.InstanceId

        # Wywołanie pnputil do odinstalowania
        pnputil /remove-device "$instanceId"
    } catch {
        Write-Host "❌ Błąd podczas usuwania: $_"
    }
}

Write-Host "`n✅ Operacja zakończona."
