# Wyświetlenie komunikatu
Write-Host "Skrypt doda uzytkownika (user) i administratora (myadmin)"
$confirmation = Read-Host "Kontynuowac? (T/N)"

# Normalizacja odpowiedzi użytkownika (ignorowanie wielkości liter)
switch ($confirmation.ToUpper()) {
    "T" { Write-Host "Kontynuuje skrypt..." }
    "N" { Write-Host "Skrypt zostal przerwany."; return }
    default { Write-Host "Niepoprawna odpowiedz. Skrypt zostal przerwany."; return }
}

$adminPasswordInput = Read-Host -AsSecureString "Podaj haslo dla konta administratora (myadmin)"
New-LocalUser -Name "myadmin" -Password $adminPasswordInput -FullName "Administrator (myadmin)" -Description "Administrator komputera" -AccountNeverExpires
Add-LocalGroupMember -Group "Administratorzy" -Member "myadmin"

$userPasswordInput = Read-Host -AsSecureString "Podaj haslo dla konta użytkownika (user)"
New-LocalUser -Name "user" -Password $userPasswordInput -FullName "User" -Description "Standard user account" -AccountNeverExpires

# SID dla grupy "Users"
$usersGroupSID = "S-1-5-32-545"
Add-LocalGroupMember -SID $usersGroupSID -Member "user"

$regKeyOOBE = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\OOBE"
if (Test-Path $regKeyOOBE) {
    Set-ItemProperty -Path $regKeyOOBE -Name "BypassNRO" -Value "1"
}

Write-Host "Zmiany w rejestrze zostały zastosowane."

Write-Host "Restartujemy komputer . . . . . ."
Sleep 1
Write-Host "Paaaaaa . . . . . ."
# Restart-Computer

