# Kolektor CipherLab CPT-8300

Pliki konfiguracyjne dla kolektora bez doku - kolektor podłączamy do komputera bezpośrednio kablem.

## Instrukcja użytkowania

Wszystkie operacja na kolektorze zaczynamy od głównego menu:

<img src="image-20211221123954206.png" alt="image-20211221123954206" style="zoom:200%;" />

Aby wrócić do tego menu należy nacisnąć kilka razy klawisz `Esc`

Po menu można poruszać się klawiszami strzałek i potwierdzać operację `Enterem` (dwa niebieskie klawisze)

W prawym dolnym rogu widoczny jest licznik odczytanych kodów - jeśli zaczynamy pracę powinien wskazywać `000000`. Jeśli jest tu inna wartość i zaczynamy skanowanie nowych danych musimy usunąć stare odczyty (patrz poniżej - Ręczne kasowanie danych).

### Przesyłanie danych do kolektora

Aby kolektor wyświetlał dane z bazy PC-Market-u musimy przesyłać do niego co jakiś czas aktualne nazwy, stany, ceny itd z programu.

> Wykonanie tego kroku nie jest niezbędne do prawidłowej pracy kolektora - tzn do importu wprowadzanych danych do programu. Nawet jeśli kolektor "nie zna" towarów (bo nie przesłaliśmy do niego aktualnej bazy z programu), ale są one w programie - zostaną prawidłowo odczytane w systemie.

W programie wybieramy kolejno `Towary -> Eksport do inwentaryzatora -> OK` 

![image-20211221123336392](image-20211221123336392.png)

Opcjonalnie w oknie tym możemy ograniczyć ilość przesyłanych danych np. do wybranego magazynu.

Po kliknięciu `OK` pojawi się okno z kolejnymi instrukcjami:

![image-20211221123715095](image-20211221123715095.png)

Podłączamy kolektor do komputera i menu urządzenia wybieramy `3. Narzędzia -> 8. Ładuj bazę` a następnie klikamy przycisk `OK` . Czekamy do końca operacji (może ona potrwać kilka-kilkanaście minut).

### Wprowadzanie danych

Dane wprowadzamy wchodząc w `1. Skanowanie -> 4. BAZA DANYCH`:

<img src="image-20211221124512819.png" alt="image-20211221124512819" style="zoom:200%;" />

Wprowadzamy kod produktu przy użyciu klawiatury lub czytnika kodów (duży żółty przycik)

Jeśli produkt został znaleziony w bazie przesłanej do kolektora, wyświetli się jego nazwa, stan, cena itd.

Jeśli nie został znaleziony wyświetli się komunikat o braku takiego kodu w bazie (potwierdzamy do `enterem`)

Następnie, w oby przypadkach, wprowadzamy ilość i potwierdzamy klawiszem `enter`.

Powtarzamy powyższe dla kolejnych towarów (Kod -> Ilość, Kod -> Ilość itd ...)

### Przesyłanie danych do komputera

Każdy dokument posiadający pozycje towarowe ma możliwość importu danych z  terminala. Aby rozpocząć import należy, będąc w trybie edycji dokumentu nacisnąć  kombinację klawiszy <kbd>Ctrl + I</kbd>. 

![image-20211221125554162](image-20211221125554162.png)

Podłączamy kolektor do komputera i w menu urządzenia wybieramy `2. Transmisja` (jeśli nie ma wprowadzonych danych (0 w prawym dolnym rogu), nie da się wejść w transmisję), a następnie klikamy przycisk `OK` . Czekamy do końca operacji.

W kolejnym oknie mamy możliwość przejrzenia odczytanych danych, jeśli wszystko się zgadza możemy przesłać je na dokument.

Na jeden dokument można wielokrotnie „doczytywać” dane z terminala lub kilku terminali „będących w obiegu”, co szczególnie przydaje się w przypadku sporządzania  np. remanentu.  

Na kolektorze pojawi się komunikat z pytaniem o kasowanie danych. Jeśli odczytały się prawidłowo to chcemy je skasować czyli wybieramy `1. Wszystko` i potwierdzamy `1. Tak`. Kolektor jest ponownie gotów do wprowadzania danych.

### Ręczne kasowanie danych

Jeśli nie usunęliśmy danych po odczycie, możemy to zrobić ręcznie. W tym celu wybieramy `3. Narzędzia -> 3. Kasowanie`. Wyświetli się lista danych do usunięcie - wybieramy pozycję `Dane`:

```
Dane     - to są dane wprowadzone przez uzytkownika 
Baza 1   - baza towarów odczytana z programu
Wszystko - oba powyższe
```

Na kolektorze pojawi się komunikat z pytaniem o kasowanie danych. Jeśli odczytały się prawidłowo to chcemy je skasować czyli wybieramy `1. Wszystko` i potwierdzamy `1. Tak`. Kolektor jest ponownie gotów do wprowadzania danych.

> Uwaga, 
>
> jeśli nie ma tego wyboru oznacza to że w kolektorze nie ma wprowadzonych danych lub bazy z komputera i pojawi się jedynie komunikat z pytaniem o kasowanie danych. 


## Instrukcja konfiguracji kolektora CPT-8300

Pliki konfiguracyjne dla kolektora bez doku - kolektor podłączamy do komputera bezpośrednio kablem.

----

### Instalacja sterownika

W katalogu `.\Sterownik` jest oprogramowanie do obsługi kabla USB `CP210x.6.7.1_VCP_Windows10` (dla Windows 10 i 11)

Instalacja polega na uruchomieniu odpowiedniego pliku, w zależności od wersji systemu operacyjnego:

- dla systemów 32-bit: `.\Sterownik\CP210xVCPInstaller_x86.exe`

- dla systemów 64-bit: `.\Sterownik\CP210xVCPInstaller_x64.exe`

Instalacja z domyślnymi ustawieniami (Dalej, Dalej, Dalej ... )

### Instalacja oprogramowania

Kopiujemy do katalogu z programem PC-market (np. `C:\Program Files\Insoft\PCMWin_7_1\`) poniższe pliki:

```bash
├── 232_Read.exe
├── 232_Read.ini
├── Data_Read.exe
├── DLookup.exe
└── Lookup.ini
```

### Konfiguracja oprogramowania komunikacyjnego

#### Oprogramowanie do odczytu danych z kolektora

W pliku `232_Read.ini` zmieniamy nr portu COM na ten pod którym "widoczny" jest kolektor w systemie.

W poniższym przykładzie 

- pierwsza `1` to typ połączenia (1-bezpośrednie połączenie kablowe, 2-dok-IR)
- `7` - to numer portu COM
- pozostałe parametry bez zmian

```ini
Data_read.exe <F>.<E>,1,7,1,1,1,1,1,0,0,0,2,2,0,0,0,0,0
```

#### Oprogramowanie do przesyłania danych do kolektora

i w pliku `Lookup.ini` interesuje nas tylko typ połączenia (tu pozostałe dane przekaże PC-Market)

```
inwout.txt // plik - nic nie ruszamy
7          // nr portu COM - ale tu nic nie ruszamy 
1          //
1          // Tu jest typ połączenia (1-bezpośrednie połączenie kablowe, 2-dok-IR) i to możemy zmienić
1
```

### Konfiguracja programu PC-Market

W programie ustawiamy kolektor wg poniższej ilustracji:

![20211221_105004505_PCMWin_QtlbtZnsMc](20211221_105004505_PCMWin_QtlbtZnsMc.png)
