class Web3Provider {
    constructor(isDebug) {
        this.lastCallbackId = 0;
        this.callbacks = new Map();
        this.onCallbacks = new Map();
        this.isOpera = true;
        this._isDebug = isDebug;
    }

    _debug(msg) {
        if (this._isDebug) {
            console.log(msg);
        }
    }

    enable() {
        this._debug("<< enable");
        return this.request({ method: "eth_requestAccounts", params: [] });
    }

    isConnected() {
        this._debug("<< isConnected");
        return true
    }

    on(eventName, callback) {
        this._debug("Event on: " + eventName);
        this.onCallbacks.set(eventName, callback);
    }

    removeListener(eventName, callback) {
        this._debug("Event off: " + eventName);
        this.onCallbacks.delete(eventName)
    }

    handleWeb3OnEvent(event, parameters) {
        const callback = this.onCallbacks.get(event);
        if (!callback) return
        callback(...parameters);
    }

    async send(payload) {
        this._debug("<< send: " + JSON.stringify(payload));
        let promise = null;
        switch (payload) {
            case "eth_accounts":
            case "eth_chainId":
            case "eth_requestAccounts":
            case "net_version":
                promise = this.request({ method: payload, params: [] })
                break;
            default:
                //todo(marcusc): throw something sensible
                throw "error"
        }
        const response = await promise;
        this._debug(">> send: " + JSON.stringify(response));
        return response
    }

    sendAsync(payload, callback) {
        this._debug("<< sendAsync: " + JSON.stringify(payload));
        const requestId = payload.id;
        this.callbacks.set(requestId, (error, data) => {
            if (error) {
                const response = { jsonrpc: "2.0", id: requestId, error: error };
                this._debug(">> sendAsync: " + JSON.stringify(response));
                callback(response, null);
            } else {
                const response = { jsonrpc: "2.0", id: requestId, result: data };
                this._debug(">> sendAsync: " + JSON.stringify(response));
                callback(null, response);
            }
        });
        _cw_.request(location.hostname, JSON.stringify(payload), requestId);
    }

    request(payload) {
        const payloadId = this.lastCallbackId++;
        this._debug("<< request[" + payloadId + "]:" + JSON.stringify(payload));
        return new Promise((resolve, reject) => {
            this.callbacks.set(payloadId, (error, data) => {
                if (error) {
                    this._debug(">> reject: request[" + payloadId + "]:" + JSON.stringify(error));
                    reject(error);
                } else {
                    this._debug(">> resolve: request[" + payloadId + "]:" + JSON.stringify(data));
                    resolve(data);
                }
            });
            _cw_.request(location.hostname, JSON.stringify(payload), payloadId);
        })
    }

    sendResult(requestId, payload) {
        const callback = this.callbacks.get(requestId);
        if (!callback) return;
        if (payload.error) {
            callback(payload.error, null);
        } else {
            callback(null, payload.result);
        }
        this.callbacks.delete(requestId);
    }
}
