/*==============================================================*/
/*Skrypt wpisujący dane demo do bazy mPOS (wszystkie urządzenia)*/
/*==============================================================*/

/* Informacja o tym, że baza nie jest pusta */
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'IsDatabaseEmpty', 0, '1', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'DatabaseType', 0, 'demo', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* PosGroup */
INSERT INTO PosGroup (PosGroupId, Name, IsActive, Creation, LastUpdate) VALUES (1, 'Liniowe', 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Pos */
INSERT INTO Pos (PosId, PosGroupId, type, Name, Number, IsActive, Creation, LastUpdate) VALUES (1, 1, 0, '1', 1, 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Currency */
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (1,1,'zł','PLN',1,1,1,'1','2022-07-27 13:24:37.495','2022-07-29 09:33:13.953');
go
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (2,1,'EUR','EUR',4.3535,1,0,'2','2022-07-27 13:24:37.556','2022-07-29 09:33:13.964');
go
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (3,1,'USD','USD',3.851,1,0,'3','2022-07-27 13:24:37.601','2022-07-29 09:33:13.974');
go

/* ShopInfo - dane sklepu */
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','name',0,'COMP SA o. Novitus','2022-08-26 07:25:01.446');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','bankaccount',0,'','2022-08-26 07:25:01.486');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','bankname',0,'','2022-08-26 07:25:01.491');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','city',0,'Nowy Sącz','2022-08-26 07:25:01.452');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','street',0,'Nawojowska','2022-08-26 07:25:01.467');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','nip',0,'5220001694','2022-08-26 07:25:01.496');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','phonenumber',0,'','2022-08-26 07:25:01.500');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','zipcode',0,'33-300','2022-08-26 07:25:01.460');
go

/* PaymentForm */
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (1,1,'Gotówka',0,'null',1,'1','2022-07-27 13:24:37.650','2022-07-29 09:33:13.985');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (2,1,'Karta pł.',2,'',0,'2','2022-07-27 13:24:37.691','2022-07-29 09:33:13.991');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (3,1,'Bon pł.',4,'null',0,'3','2022-07-27 13:24:37.741','2022-07-29 09:33:13.996');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (4,1,'Przelew',5,'null',0,'4','2022-07-27 13:24:37.793','2022-07-29 09:33:14.002');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (5,0,'karta demo',2,'UposDemo',1,'5','2022-07-28 13:27:23.054','2022-07-29 09:30:01.014');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (6,0,'kartwa 3',2,'Elavon2',1,'6','2022-07-28 13:27:23.104','2022-07-29 09:30:01.008');
go

/* Operator */
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (1,3,NULL,1,1,'','Jan Kowalski','','','2',NULL,'','Jan Kowalski',0,NULL,NULL,'2022-07-27 13:24:37.280','2022-07-29 09:33:13.909');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (2,1,NULL,1,2,'','Anna Wójcik','','','3',NULL,'','Anna Wójcik',0,NULL,NULL,'2022-07-27 13:24:37.332','2022-07-29 09:33:13.917');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (3,1,NULL,1,3,'','Paulina Matusik','','','4',NULL,'','Paulina Matusik',0,NULL,NULL,'2022-07-27 13:24:37.377','2022-07-29 09:33:13.927');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (4,2,NULL,1,4,'','Eugeniusz Nowak','','','5',NULL,'','Eugeniusz Nowak',0,NULL,NULL,'2022-07-27 13:24:37.432','2022-07-29 09:33:13.936');
go

/* Customer */
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (1,NULL,1,'COMP SA 1','Sklep nr 1','Nowy Sącz','33-300','Nowy Sącz','Rynek','5','',NULL,'','1234567891','','',NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,1,0,'1','2022-07-27 13:24:39.281','2022-07-27 13:24:39.281',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (2,NULL,1,'Codziennik Dostawca Prasy','','Warszawa','00-734','Warszawa','Złotej Jesieni 54','','',NULL,'','123-65-56-567','','codziennik@onet.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'2','2022-07-27 13:24:39.336','2022-07-27 13:24:39.336',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (3,NULL,1,'Gospodarz Gospodarstwo Rolne','','Turek','62-733','Turek','Zielona 14','','',NULL,'','213-243-24-11','','biuro@gospodarz.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'3','2022-07-27 13:24:39.388','2022-07-27 13:24:39.388',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (4,NULL,1,'Oskarek Antoni Oskariusz','','Wyszków','65-969','Wyszków','Oskarowa 25','','',NULL,'','365-69-63-123','','info@oskarek.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,0,0,0,'4','2022-07-27 13:24:39.454','2022-07-27 13:24:39.454',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (5,NULL,1,'F.P.H.U. Józef Kowalczyk','','Gdańsk','80-122','Gdańsk','Nadmorska 134/22','','',NULL,'','987-98-98-999','','jozef@kowalczyk.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,0,0,0,'5','2022-07-27 13:24:39.518','2022-07-27 13:24:39.518',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (6,NULL,1,'Firma Handlowa „Komputerek”','','Suwałki','16-400','Suwałki','Źródlana 151','','',NULL,'','345-65-65-765','','biuro@komputerek.info',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'6','2022-07-27 13:24:39.585','2022-07-27 13:24:39.585',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (7,NULL,1,'Firma Handlowo-Usługowa „Tęcza”','','Kraków','30-205','Kraków','Warszawska 77','','',NULL,'','777-12-23-154','','salon@tecza.com',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'7','2022-07-27 13:24:39.651','2022-07-27 13:24:39.651',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (8,NULL,1,'Hurtownia Sprzętu AGD','','Bartoszyce','11-276','Bartoszyce','Plac Teatralny 23','','',NULL,'','763-88-99-098','','agd@hurtownia.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'8','2022-07-27 13:24:39.704','2022-07-27 13:24:39.704',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (9,NULL,1,'Hurtownia Techniczna „Technet”','','Siedlce','08-134','Siedlce','Alpejska 99','','',NULL,'','321-32-32-432','','office@technet.com',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'9','2022-07-27 13:24:39.772','2022-07-27 13:24:39.772',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (10,NULL,1,'Mleczarnia „Łaciata”','','Grudziądz','86-330','Grudziądz','11 Listopada 87','','',NULL,'','521-52-51-213','','laciata@krowa.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'10','2022-07-27 13:24:39.817','2022-07-27 13:24:39.817',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (11,NULL,1,'Piekarnia „Złoty łan”','','Śrem','63-115','Śrem','Poprzeczna 4','','',NULL,'','654-43-43-456','','info@zloty.com',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'11','2022-07-27 13:24:39.875','2022-07-27 13:24:39.875',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (12,NULL,1,'Polskie Zakłady Spirytusowe Polmos','','Biała Podlaska','21-534','Biała Podlaska','Kajakowa 267','','',NULL,'','376-76-76-376','','polmos@polmos.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'12','2022-07-27 13:24:39.931','2022-07-27 13:24:39.931',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (13,NULL,1,'Przedsiębiorstwo Przemysłowe „Metaleks”','','Mińsk Mazowiecki','05-321','Mińsk Mazowiecki','Deptak 83','','',NULL,'','666-54-45-777','','biuro@metaleks.com',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'13','2022-07-27 13:24:39.989','2022-07-27 13:24:39.989',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (14,NULL,1,'Szkoła Podstawowa nr 144','','Katowice','40-350','Katowice','Marynarska 45','','',NULL,'','234-56-78-901','','144@szkoly.info',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,0,0,0,'14','2022-07-27 13:24:40.047','2022-07-27 13:24:40.047',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (15,NULL,1,'Wytwórnia Butów Sportowych','','Poznań','61-005','Poznań','Kazimierza Wielkiego 45/15','','',NULL,'','901-01-01-110','','relax@buty.info',NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,0,0,'15','2022-07-27 13:24:40.102','2022-07-27 13:24:40.102',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (16,NULL,1,'Zakład Produkcji Odzieży','','Stargard','73-100','Stargard','Samorządowa 15b','','',NULL,'','871-12-12-345','','zamowienia@odziez.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,1,0,0,'16','2022-07-27 13:24:40.169','2022-07-27 13:24:40.169',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (17,NULL,1,'COMP SPÓŁKA AKCYJNA','','Warszawa','02-230','Warszawa','ul. Jutrzenki','116','',NULL,'','5220001694','225703800','info@comp.com.pl',NULL,NULL,NULL,NULL,NULL,NULL,1,1,0,0,0,0,'17','2022-07-27 13:56:00.645','2022-07-27 13:57:36.338',NULL,NULL,NULL,'MAZOWIECKIE','Warszawa','Włochy','',NULL,NULL);
go

/* ProductGroup */
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (1,1,'Alkohole',NULL,NULL,0,0,0,'1','2022-07-27 13:24:37.860','2022-07-29 09:33:14.017',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (2,1,'Chemia',NULL,NULL,0,0,0,'2','2022-07-27 13:24:37.894','2022-07-29 09:33:14.023',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (3,1,'Dania obiadowe',NULL,NULL,0,0,0,'3','2022-07-27 13:24:37.936','2022-07-29 09:33:14.029',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (4,1,'Kawy',NULL,NULL,0,0,0,'4','2022-07-27 13:24:37.978','2022-07-29 09:33:14.035',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (5,1,'Kosmetyki',NULL,NULL,0,0,0,'5','2022-07-27 13:24:38.028','2022-07-29 09:33:14.041',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (6,1,'Napoje',NULL,NULL,0,0,0,'6','2022-07-27 13:24:38.078','2022-07-29 09:33:14.047',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (7,1,'Opakowania',NULL,NULL,0,0,0,'7','2022-07-27 13:24:38.127','2022-07-29 09:33:14.053',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (8,1,'Owoce i warzywa',NULL,NULL,0,0,0,'8','2022-07-27 13:24:38.174','2022-07-29 09:33:14.059',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (9,1,'Pieczywo',NULL,NULL,0,0,0,'9','2022-07-27 13:24:38.224','2022-07-29 09:33:14.065',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (10,1,'Słodycze',NULL,NULL,0,0,0,'10','2022-07-27 13:24:38.274','2022-07-29 09:33:14.084',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (11,1,'Usługi',NULL,NULL,0,0,0,'11','2022-07-27 13:24:38.327','2022-07-29 09:33:14.095',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (12,1,'Zestawy',NULL,NULL,0,0,0,'12','2022-07-27 13:24:38.381','2022-07-29 09:33:14.102',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (13,1,'RTV',NULL,NULL,0,0,0,'13','2022-07-27 13:24:38.426','2022-07-29 09:33:14.109',0,0,0,0);
go

/* VatRate */
INSERT INTO "VatRate" ("VatRateId","IsActive","Value","ExternalId","Creation","LastUpdate") VALUES (1,1,-1,'-1','2022-07-27 13:24:35.708','2022-08-26 07:32:52.935');
go
INSERT INTO "VatRate" ("VatRateId","IsActive","Value","ExternalId","Creation","LastUpdate") VALUES (2,1,0,'0','2022-07-27 13:24:35.718','2022-07-29 09:33:13.829');
go
INSERT INTO "VatRate" ("VatRateId","IsActive","Value","ExternalId","Creation","LastUpdate") VALUES (3,1,500,'500','2022-07-27 13:24:35.727','2022-07-29 09:33:13.832');
go
INSERT INTO "VatRate" ("VatRateId","IsActive","Value","ExternalId","Creation","LastUpdate") VALUES (4,1,800,'800','2022-07-27 13:24:35.735','2022-07-29 09:33:13.837');
go
INSERT INTO "VatRate" ("VatRateId","IsActive","Value","ExternalId","Creation","LastUpdate") VALUES (5,1,2300,'2300','2022-07-27 13:24:35.743','2022-07-29 09:33:13.841');
go

/* VatRateLtr */
INSERT INTO VatRateLtr (Letter,Value) VALUES ('A',2300);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('B',800);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('C',500);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('D',0);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('E',-1);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('F',-2);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('G',-2);
go

/* UnitName */
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (1,1,'kg',-3,'1','2022-07-27 13:24:35.827','2022-07-29 09:33:13.886');
go
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (2,1,'opak',0,'2','2022-07-27 13:24:35.878','2022-07-29 09:33:13.891');
go
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (3,1,'szt',0,'3','2022-07-27 13:24:35.931','2022-07-29 09:33:13.896');
go

/* Product */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (2,1,6,3,NULL,5,NULL,'7 UP Napój Gazowany puszka 250ml','',1.8,1.8,1.8,1.8,NULL,NULL,0,0,'',1,0,NULL,0,'','2','2022-07-27 13:24:55.540','2022-07-29 09:28:19.362',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (3,1,6,3,NULL,5,NULL,'Cappy Sok Pomarańczowy 330ml','',2.6,2.6,2.6,2.6,NULL,NULL,0,0,'',1,0,NULL,0,'','3','2022-07-27 13:24:55.563','2022-07-27 13:30:10.439',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (4,1,6,3,NULL,5,NULL,'Cisowianka Woda Mineralna Gazowana 1.5l','',1.95,1.95,1.95,1.95,NULL,NULL,0,0,'',1,0,NULL,0,'','4','2022-07-27 13:24:55.586','2022-07-27 13:30:10.456',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (5,1,6,3,NULL,5,NULL,'Coca-Cola Napój Gazowany Puszka 250ml','',2.4,2.4,2.4,2.4,NULL,NULL,0,0,'',1,0,NULL,0,'','5','2022-07-27 13:24:55.610','2022-07-27 13:30:10.472',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (6,1,6,3,NULL,5,NULL,'Coca-Cola Napój Gazowany 1l','',4.5,4.5,4.5,4.5,NULL,NULL,0,0,'',1,0,NULL,0,'','6','2022-07-27 13:24:55.632','2022-07-27 13:30:10.488',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (7,1,6,3,NULL,5,NULL,'Fanta Pomarańczowa Napój Gazowany 1l','',4.2,4.2,4.2,4.2,NULL,NULL,0,0,'',1,0,NULL,0,'','7','2022-07-27 13:24:55.655','2022-07-27 13:30:10.515',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (8,1,6,3,NULL,5,NULL,'Garden Napój Jabłko Antonówka 2l','',5.2,5.2,5.2,5.2,NULL,NULL,0,0,'',1,0,NULL,0,'','8','2022-07-27 13:24:55.680','2022-07-27 13:30:10.540',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (9,1,6,3,NULL,5,NULL,'Garden Napój Pomarańczowy 2l','',3.5,3.5,3.5,3.5,NULL,NULL,0,0,'',1,0,NULL,0,'','9','2022-07-27 13:24:55.698','2022-07-27 13:30:10.564',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (10,1,6,3,NULL,5,NULL,'Kropla Beskidu Woda Mineralna Gazowana 1.5l','',2.5,2.5,2.5,2.5,NULL,NULL,0,0,'',1,0,NULL,0,'','10','2022-07-27 13:24:55.716','2022-07-27 13:30:10.589',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (11,1,6,3,NULL,5,NULL,'Nestle Aquarel Napój Niegazowany 0,5l','',2,2,2,2,NULL,NULL,0,0,'',1,0,NULL,0,'','11','2022-07-27 13:24:55.732','2022-07-27 13:30:10.600',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (12,1,6,3,NULL,5,NULL,'Pepsi Napój Gazowany 1l','',4.4,4.4,4.4,4.4,NULL,NULL,0,0,'',1,0,NULL,0,'','12','2022-07-27 13:24:55.751','2022-07-27 13:30:10.615',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (13,1,6,3,NULL,5,NULL,'Sprite Napój Gazowany 1l','',4.1,4.1,4.1,4.1,NULL,NULL,0,0,'',1,0,NULL,0,'','13','2022-07-27 13:24:55.770','2022-07-27 13:30:10.629',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (14,1,6,3,NULL,5,NULL,'Tymbark Napój Jabłkowo-Miętowy 250ml','',2.3,2.3,2.3,2.3,NULL,NULL,0,0,'',1,0,NULL,0,'','14','2022-07-27 13:24:55.788','2022-07-27 13:30:10.644',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (15,1,6,3,NULL,5,NULL,'Tymbark Sok Jabłkowy 0,2l','',0.9,0.9,0.9,0.9,NULL,NULL,0,0,'',1,0,NULL,0,'','15','2022-07-27 13:24:55.807','2022-07-27 13:30:10.659',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (16,1,6,3,NULL,5,NULL,'Kubuś Sok Marchwiowo-Truskawkowy 330ml','',2,2,2,2,NULL,NULL,0,0,'',1,0,NULL,0,'','16','2022-07-27 13:24:55.826','2022-07-29 09:30:03.643',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (17,1,10,3,0,5,NULL,'Alpejskie Mleczko 380g.Waniliowe','',15.5,0,0,0,NULL,0,0,0,'',1,0,NULL,0,'','17','2022-07-27 13:24:55.843','2022-07-28 11:04:28.408',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (18,1,10,3,NULL,5,NULL,'Baton Grześki Kakaowe 27g','',1.2,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','18','2022-07-27 13:24:55.859','2022-07-29 09:30:03.662',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (19,1,10,3,NULL,5,NULL,'Baton Grześki Orzechowe 39g','',1.1,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','19','2022-07-27 13:24:55.875','2022-07-27 13:30:10.713',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (20,1,10,3,NULL,5,NULL,'Baton Kinder Delice Kakao','',2.2,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','20','2022-07-27 13:24:55.892','2022-07-27 13:30:10.726',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (21,1,10,3,NULL,5,NULL,'Baton Lion Peanut 41g','',1.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','21','2022-07-27 13:24:55.908','2022-07-27 13:30:10.739',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (22,1,10,3,NULL,5,NULL,'Baton Mars','',1.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','22','2022-07-27 13:24:55.924','2022-07-27 13:30:10.753',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (23,1,10,3,NULL,5,NULL,'Baton Maxser Xxl 51g','',1.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','23','2022-07-27 13:24:55.939','2022-07-27 13:30:10.765',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (24,1,10,3,NULL,5,NULL,'Baton Mc Kokosowy W Czeko. 40','',1,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','24','2022-07-27 13:24:55.954','2022-07-27 13:30:10.777',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (25,1,10,3,NULL,5,NULL,'Baton Milky Way 25g','',1.3,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','25','2022-07-27 13:24:55.969','2022-07-27 13:30:10.791',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (26,1,10,3,NULL,5,NULL,'Baton Pawełek Adwokat 45g','',1.6,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','26','2022-07-27 13:24:55.985','2022-07-27 13:30:10.803',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (27,1,10,3,NULL,5,NULL,'Baton Prince Polo Mleczne Xxl','',1.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','27','2022-07-27 13:24:56.000','2022-07-27 13:30:10.815',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (28,1,10,3,0,5,NULL,'Ciastka Delicje Pomara.294g','',5.99,0,0,0,NULL,0,0,0,'',1,0,NULL,0,'','28','2022-07-27 13:24:56.019','2022-07-28 11:04:31.701',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (29,1,10,3,NULL,5,NULL,'Ciastka Delicje Wiśniowe 294g','',5.99,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','29','2022-07-27 13:24:56.038','2022-07-27 13:30:10.840',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (30,1,10,3,0,5,NULL,'Ciastka Familijne 180g','',3.8,0,0,0,NULL,0,0,0,'',1,0,NULL,0,'','30','2022-07-27 13:24:56.058','2022-07-28 11:04:33.714',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (31,1,10,3,NULL,5,NULL,'Czekolada E.Wedel Mleczna','',3.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','31','2022-07-27 13:24:56.077','2022-07-27 13:30:10.866',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (32,1,10,3,NULL,5,NULL,'Guma Airwaves Classic Torebka','',3.2,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','32','2022-07-27 13:24:56.099','2022-07-27 13:30:10.877',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (33,1,10,3,NULL,5,NULL,'Guma Orbit Aple Torebka','',3.2,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','33','2022-07-27 13:24:56.116','2022-07-27 13:30:10.890',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (34,1,2,3,NULL,5,NULL,'Chusteczki Higieniczne','',1,1,1,1,NULL,NULL,0,0,'',1,0,NULL,0,'','34','2022-07-27 13:24:56.127','2022-07-27 13:30:10.902',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (35,1,4,3,0,5,NULL,'Kawa Jacobs Kronung 100g','',5.2,0,0,0,NULL,0,0,0,'',1,0,NULL,0,'','35','2022-07-27 13:24:56.139','2022-07-28 11:04:54.965',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (36,1,4,3,NULL,5,NULL,'Kawa Pedros 100g','',6.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','36','2022-07-27 13:24:56.150','2022-07-27 13:30:10.926',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (37,1,4,3,NULL,5,NULL,'Kawa Tchibo Exclusive 100g','',7.2,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','37','2022-07-27 13:24:56.163','2022-07-27 13:30:10.936',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (38,1,10,3,NULL,5,NULL,'Orzeszki Felix 300g Papryka','',9,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','38','2022-07-27 13:24:56.176','2022-07-27 13:30:10.947',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (39,1,10,3,NULL,5,NULL,'Paluszki Junor Safari 125g','',3.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','39','2022-07-27 13:24:56.190','2022-07-27 13:30:10.957',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (40,1,10,3,NULL,5,NULL,'Ptasie Mleczko Waniliowe 420g','',15.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','40','2022-07-27 13:24:56.204','2022-07-27 13:30:10.970',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (41,1,4,3,NULL,5,NULL,'Kawa Nescafe 250g','',17.3,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','41','2022-07-27 13:24:56.221','2022-07-27 13:30:10.985',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (42,1,4,3,NULL,5,NULL,'Kawa Lavazza 500g','',28.5,0,0,0,NULL,NULL,0,0,'',1,0,NULL,0,'','42','2022-07-27 13:24:56.239','2022-07-27 13:30:11.003',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (43,1,6,3,NULL,5,NULL,'Natural Active Woda Źródlana 1.5l','',3,3,3,3,NULL,NULL,0,0,'',1,0,NULL,0,'','43','2022-07-27 13:24:56.256','2022-07-29 09:30:03.681',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (44,1,6,3,NULL,5,NULL,'Frugo Czerwone Napój Owocowy 250ml','',1.25,1.25,1.25,1.25,NULL,NULL,0,0,'',1,0,NULL,0,'','44','2022-07-27 13:24:56.273','2022-07-27 13:30:11.036',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (45,1,6,3,NULL,5,NULL,'Hortex Vitaminka Napój Marchew-Jabłko 250ml','',1.65,1.65,1.65,1.65,NULL,NULL,0,0,'',1,0,NULL,0,'','45','2022-07-27 13:24:56.296','2022-07-27 13:30:11.054',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (46,1,6,3,NULL,5,NULL,'Black Sex Napój Energetyczny Puszka 250ml','',1.9,1.9,1.9,1.9,NULL,NULL,0,0,'',1,0,NULL,0,'','46','2022-07-27 13:24:56.311','2022-07-27 13:30:11.071',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (47,1,6,3,NULL,5,NULL,'Red Bull Napój Energetyczny Puszka 250ml','',5.55,5.55,5.55,5.55,NULL,NULL,0,0,'',1,0,NULL,0,'','47','2022-07-27 13:24:56.327','2022-07-27 13:30:11.089',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (48,1,9,3,NULL,4,NULL,'Chleb razowy ze słonecznikiem','',5.79,5.79,5.79,5.79,NULL,NULL,0,0,'',1,0,NULL,0,'','48','2022-07-27 13:24:56.342','2022-07-27 13:30:11.106',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (49,1,9,3,NULL,4,NULL,'Chleb z czarnuszką z Piekarni Ziarno','',3.39,3.39,3.39,3.39,NULL,NULL,0,0,'',1,0,NULL,0,'','49','2022-07-27 13:24:56.355','2022-07-27 13:30:11.127',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (50,1,9,3,NULL,4,NULL,'Chleb wiejski pszenny na drożdżach Piekarnia Madej','',3.39,3.39,3.39,3.39,NULL,NULL,0,0,'',1,0,NULL,0,'','50','2022-07-27 13:24:56.367','2022-07-27 13:30:11.140',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (51,1,9,3,NULL,4,NULL,'Chleb żytni tradycyjny na zakwasie','',5.3,5.3,5.3,5.3,NULL,NULL,0,0,'',1,0,NULL,0,'','51','2022-07-27 13:24:56.381','2022-07-28 11:12:38.317',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (52,1,9,3,NULL,4,NULL,'Bagietka czosnkowa - wypiekana na miejscu','',3.49,3.49,3.49,3.49,NULL,NULL,0,0,'',1,0,NULL,0,'','52','2022-07-27 13:24:56.394','2022-07-27 13:30:11.165',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (53,1,8,1,NULL,4,NULL,'Pomidory malinowe świeże','',7.99,7.99,7.99,7.99,NULL,NULL,0,0,'',1,0,NULL,0,'','53','2022-07-27 13:24:56.407','2022-07-28 11:12:38.336',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (54,1,8,3,NULL,4,NULL,'Rzodkiewka pęczek','',1.49,1.49,1.49,1.49,NULL,NULL,0,0,'',1,0,NULL,0,'','54','2022-07-27 13:24:56.420','2022-07-27 13:30:11.190',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (55,1,8,3,NULL,4,NULL,'Avokado extra','',4.99,4.99,4.99,4.99,NULL,NULL,0,0,'',1,0,NULL,0,'','55','2022-07-27 13:24:56.433','2022-07-27 13:30:11.201',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (56,1,8,1,NULL,4,NULL,'Ziemniaki młode','',4.39,4.39,4.39,4.39,NULL,NULL,0,0,'',1,0,NULL,0,'','56','2022-07-27 13:24:56.446','2022-07-27 13:30:11.213',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (57,1,8,3,NULL,4,NULL,'Szczypiorek pęczek','',0.99,0.99,0.99,0.99,NULL,NULL,0,0,'',1,0,NULL,0,'','57','2022-07-27 13:24:56.461','2022-07-27 13:30:11.225',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (58,1,8,3,NULL,4,NULL,'Pomidory koktajlowe cherry 500g','',5.99,5.99,5.99,5.99,NULL,NULL,0,0,'',1,0,NULL,0,'','58','2022-07-27 13:24:56.475','2022-07-29 09:30:03.701',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (59,1,8,1,NULL,4,NULL,'Ogórek polski szklarniowy','',4.49,4.49,4.49,4.49,NULL,NULL,0,0,'',1,0,NULL,0,'','59','2022-07-27 13:24:56.488','2022-07-27 13:30:11.251',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (60,1,8,1,NULL,4,NULL,'Jabłka z polskich sadów','',2.99,2.99,2.99,2.99,NULL,NULL,0,0,'',1,0,NULL,0,'','60','2022-07-27 13:24:56.501','2022-07-28 11:12:38.352',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (61,1,8,3,NULL,4,NULL,'Papryka czerwona','',9.99,9.99,9.99,9.99,NULL,NULL,0,0,'',1,0,NULL,0,'','61','2022-07-27 13:24:56.514','2022-07-27 13:30:11.275',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (62,1,8,1,NULL,4,NULL,'Kapusta pekińska','',2.99,2.99,2.99,2.99,NULL,NULL,0,0,'',1,0,NULL,0,'','62','2022-07-27 13:24:56.527','2022-07-28 11:12:38.367',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (63,1,5,3,NULL,5,NULL,'Colgate Total Original pasta do zębów 100ml','',8.99,8.99,8.99,8.99,NULL,NULL,0,0,'',1,0,NULL,0,'','63','2022-07-27 13:24:56.540','2022-07-27 13:30:11.301',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (64,1,5,3,NULL,5,NULL,'Palmolive Men Fresh żel pod prysznic 500ml','',14.99,14.99,14.99,14.99,NULL,NULL,0,0,'',1,0,NULL,0,'','64','2022-07-27 13:24:56.556','2022-07-27 13:30:11.314',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (65,1,5,3,NULL,5,NULL,'Mydło w płynie jabłkowe 400ml','',9.99,9.99,9.99,9.99,NULL,NULL,0,0,'',1,0,NULL,0,'','65','2022-07-27 13:24:56.571','2022-07-27 13:30:11.328',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (66,1,2,3,NULL,5,NULL,'Perlux White Kapsułki do prania 24 szt.','',29.99,29.99,29.99,29.99,NULL,NULL,0,0,'',1,0,NULL,0,'','66','2022-07-27 13:24:56.589','2022-07-27 13:30:11.342',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (67,1,2,3,NULL,5,NULL,'Velvet Jumbo Ręcznik papierowy','',16.99,16.99,16.99,16.99,NULL,NULL,0,0,'',1,0,NULL,0,'','67','2022-07-27 13:24:56.607','2022-07-27 13:30:11.355',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (68,1,2,3,NULL,5,NULL,'Ajax Floral Fiesta Konwalie Płyn uniwersalny 1l','',8.99,8.99,8.99,8.99,NULL,NULL,0,0,'',1,0,NULL,0,'','68','2022-07-27 13:24:56.622','2022-07-29 09:30:03.725',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (69,1,5,3,NULL,5,NULL,'Dove Kremowa kostka myjąca 100 g','',3.19,3.19,3.19,3.19,NULL,NULL,0,0,'',1,0,NULL,0,'','69','2022-07-27 13:24:56.637','2022-07-27 13:30:11.382',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (70,1,5,3,NULL,5,NULL,'STR8 original Dezodorant 150ml','',14.99,14.99,14.99,14.99,NULL,NULL,0,0,'',1,0,NULL,0,'','70','2022-07-27 13:24:56.652','2022-07-27 13:30:11.396',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (71,1,5,3,NULL,5,NULL,'Dove Men plus Antyperspirant w sztyfcie 50 ml','',15.99,15.99,15.99,15.99,NULL,NULL,0,0,'',1,0,NULL,0,'','71','2022-07-27 13:24:56.667','2022-07-27 13:30:11.411',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (72,1,5,3,NULL,5,NULL,'Dove Natural Touch Dead Sea Minerals 150 ml','',14.99,14.99,14.99,14.99,NULL,NULL,0,0,'',1,0,NULL,0,'','72','2022-07-27 13:24:56.681','2022-07-27 13:30:11.424',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (73,1,5,3,NULL,5,NULL,'Rexona Sexy Bouquet dezodorant 150ml','',13.49,13.49,13.49,13.49,NULL,NULL,0,0,'',1,0,NULL,0,'','73','2022-07-27 13:24:56.696','2022-07-27 13:30:11.438',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (74,1,5,3,NULL,5,NULL,'Nivea Men Stress Protect 48 h w kulce 50 ml','',12.49,12.49,12.49,12.49,NULL,NULL,0,0,'',1,0,NULL,0,'','74','2022-07-27 13:24:56.711','2022-07-27 13:30:11.452',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (75,1,5,3,NULL,5,NULL,'Gillette Series Żel do golenia 200 ml','',14.99,14.99,14.99,14.99,NULL,NULL,0,0,'',1,0,NULL,0,'','75','2022-07-27 13:24:56.726','2022-07-27 13:30:11.466',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (76,1,5,3,NULL,5,NULL,'Nivea Men Invisible for Black and White 150 ml','',12.49,12.49,12.49,12.49,NULL,NULL,0,0,'',1,0,NULL,0,'','76','2022-07-27 13:24:56.741','2022-07-27 13:30:11.480',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (77,1,5,3,NULL,5,NULL,'Nivea Creme Krem 50 ml','',4.49,4.49,4.49,4.49,NULL,NULL,0,0,'',1,0,NULL,0,'','77','2022-07-27 13:24:56.755','2022-07-27 13:30:11.494',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (78,1,5,3,NULL,5,NULL,'Nivea Men Sport Żel pod prysznic 250 ml','',9.99,9.99,9.99,9.99,NULL,NULL,0,0,'',1,0,NULL,0,'','78','2022-07-27 13:24:56.770','2022-07-27 13:30:11.508',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (79,1,5,3,NULL,5,NULL,'Ziaja Yego Dezodorant antyperspirant roll-on','',6.99,6.99,6.99,6.99,NULL,NULL,0,0,'',1,0,NULL,0,'','79','2022-07-27 13:24:56.785','2022-07-27 13:30:11.522',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (80,1,5,3,NULL,5,NULL,'Fa Sport Energizing Fresh Dezodorant 150 ml','',8.99,8.99,8.99,8.99,NULL,NULL,0,0,'',1,0,NULL,0,'','80','2022-07-27 13:24:56.800','2022-07-27 13:30:11.535',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (81,1,2,3,NULL,5,NULL,'Woolite Perła Extra Płyn do prania 2 l','',19.99,19.99,19.99,19.99,NULL,NULL,0,0,'',1,0,NULL,0,'','81','2022-07-27 13:24:56.815','2022-07-29 09:30:03.743',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (82,1,2,3,NULL,5,NULL,'Cif Ultra Biel Mleczko z wybielaczem 700 ml','',9.99,9.99,9.99,9.99,NULL,NULL,0,0,'',1,0,NULL,0,'','82','2022-07-27 13:24:56.834','2022-07-27 13:30:11.563',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (83,1,2,3,NULL,5,NULL,'Vanish Oxi Action Odplamiacz do tkanin 500 g','',29.99,29.99,29.99,29.99,NULL,NULL,0,0,'',1,0,NULL,0,'','83','2022-07-27 13:24:56.852','2022-07-27 13:30:11.577',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (84,1,2,3,NULL,5,NULL,'Cillit Kamień i rdza Żel 450 g','',15.9,15.9,15.9,15.9,NULL,NULL,0,0,'',1,0,NULL,0,'','84','2022-07-27 13:24:56.874','2022-07-27 13:30:11.591',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (85,1,2,3,NULL,5,NULL,'Mr Muscle 5w1Płyn w rozpylaczu 500 ml','',10.49,10.49,10.49,10.49,NULL,NULL,0,0,'',1,0,NULL,0,'','85','2022-07-27 13:24:56.892','2022-07-27 13:30:11.607',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (86,1,2,3,NULL,5,NULL,'Płyn do szyb cytrusowy 500ml','',5.99,5.99,5.99,5.99,NULL,NULL,0,0,'',1,0,NULL,0,'','86','2022-07-27 13:24:56.907','2022-07-27 13:30:11.623',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (87,1,2,3,NULL,5,NULL,'Biały Jeleń Hipoalergiczny balsam do naczyń 1l','',6.99,6.99,6.99,6.99,NULL,NULL,0,0,'',1,0,NULL,0,'','87','2022-07-27 13:24:56.921','2022-07-27 13:30:11.639',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (88,1,2,3,NULL,5,NULL,'Glade by Brise odświeżacz powietrza 269ml','',26.9,26.9,26.9,26.9,NULL,NULL,0,0,'',1,0,NULL,0,'','88','2022-07-27 13:24:56.936','2022-07-27 13:30:11.662',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (89,1,2,3,NULL,5,NULL,'Frosch żel do zmywarki limonkowy 650 ml','',29.99,29.99,29.99,29.99,NULL,NULL,0,0,'',1,0,NULL,0,'','89','2022-07-27 13:24:56.951','2022-07-27 13:30:11.675',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (90,1,2,3,NULL,5,NULL,'Air Wick Freshmatic Max Wkład 250 ml','',14.9,14.9,14.9,14.9,NULL,NULL,0,0,'',1,0,NULL,0,'','90','2022-07-27 13:24:56.963','2022-07-29 09:33:14.665',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (91,1,2,3,NULL,5,NULL,'Biały Jeleń Hipoalerg proszek do prania 500g','',7.99,7.99,7.99,7.99,NULL,NULL,0,0,'',1,0,NULL,0,'','91','2022-07-27 13:24:56.977','2022-07-27 13:30:11.701',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (92,1,2,3,NULL,5,NULL,'JELP Gel Color Hipoalergiczny żel 1 L','',26.9,26.9,26.9,26.9,NULL,NULL,0,0,'',1,0,NULL,0,'','92','2022-07-27 13:24:56.992','2022-07-27 13:30:11.714',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (93,1,2,3,NULL,5,NULL,'Visir Color Proszek do prania 300g','',4.79,4.79,4.79,4.79,NULL,NULL,0,0,'',1,0,NULL,0,'','93','2022-07-27 13:24:57.010','2022-07-27 13:30:11.728',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (94,1,2,2,NULL,5,NULL,'Ariel Color Proszek do prania 300 g','',6.99,6.99,6.99,6.99,NULL,NULL,0,0,'',1,0,NULL,0,'','94','2022-07-27 13:24:57.028','2022-07-27 13:30:11.742',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (95,1,2,3,NULL,5,NULL,'Perwoll Wool&Silk Płyn do prania wełny 2 l','',21.9,21.9,21.9,21.9,NULL,NULL,0,0,'',1,0,NULL,0,'','95','2022-07-27 13:24:57.045','2022-07-27 13:30:11.756',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (96,1,2,3,NULL,5,NULL,'Zdarzenie','',7.99,7.99,7.99,7.99,NULL,NULL,0,0,'',1,0,NULL,0,'','96','2022-07-27 13:24:57.060','2022-07-27 13:30:11.769',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (97,1,2,2,NULL,5,NULL,'Jan Niezbędny Ściereczki nasączane 40 sztuk','',7.99,7.99,7.99,7.99,NULL,NULL,0,0,'',1,0,NULL,0,'','97','2022-07-27 13:24:57.074','2022-07-27 13:30:11.783',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (98,1,2,3,NULL,5,NULL,'Cillit Bang spray - Kamień i Brud 750ml','',16.49,16.49,16.49,16.49,NULL,NULL,0,0,'',1,0,NULL,0,'','98','2022-07-27 13:24:57.091','2022-07-27 13:30:11.797',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (99,1,2,3,NULL,5,NULL,'Ajax Spray do łazienki 500ml','',12.9,12.9,12.9,12.9,NULL,NULL,0,0,'',1,0,NULL,0,'','99','2022-07-27 13:24:57.107','2022-07-27 13:30:11.810',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (100,1,2,3,NULL,5,NULL,'Kret Żel do udrożniania rur','',13.9,13.9,13.9,13.9,NULL,NULL,0,0,'',1,0,NULL,0,'','100','2022-07-27 13:24:57.121','2022-07-27 13:30:11.824',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (101,1,2,3,NULL,5,NULL,'Pronto 5in1 Płyn do paneli 750 ml','',15.49,15.49,15.49,15.49,NULL,NULL,0,0,'',1,0,NULL,0,'','101','2022-07-27 13:24:57.136','2022-07-27 13:30:11.839',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (134,1,13,3,NULL,5,NULL,'Oświetlenie Led','',49,49,49,49,NULL,NULL,0,0,'',1,0,NULL,1,'1','118','2022-07-27 13:27:27.910','2022-07-27 13:53:07.149',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (135,1,13,1,NULL,5,NULL,'Ładowarka samochodowa','',15,15,15,15,NULL,NULL,0,0,'',1,0,NULL,0,'','136','2022-07-27 13:27:27.926','2022-07-28 11:49:24.103',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (136,1,13,3,NULL,5,NULL,'Monitor 24 LCD','',499,499,499,499,NULL,NULL,0,0,'',1,0,NULL,0,'','137','2022-07-27 13:27:27.939','2022-07-28 11:50:39.960',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (137,1,13,1,NULL,5,NULL,'Słuchawki','',144.99,144.99,144.99,144.99,NULL,NULL,0,0,'',1,0,NULL,0,'','138','2022-07-27 13:27:27.954','2022-07-28 11:50:39.981',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (138,1,13,1,NULL,5,NULL,'Zegar ścienny','',99,99,99,99,NULL,NULL,0,0,'',1,0,NULL,0,'','139','2022-07-27 13:27:27.969','2022-07-28 11:50:39.999',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (139,1,13,3,NULL,5,NULL,'Zestaw głośników 5+1','',1499,1499,1499,1499,NULL,NULL,0,0,'',1,0,NULL,0,'','140','2022-07-27 13:27:27.984','2022-07-28 10:42:28.201',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (141,1,10,3,NULL,5,NULL,'Tort okolicznościowy','',100,100,100,100,NULL,NULL,0,0,'',1,0,NULL,0,'','141','2022-07-27 14:21:10.591','2022-07-28 10:49:47.817',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (142,1,4,3,NULL,5,NULL,'Kawa biała','',8,8,8,8,NULL,NULL,0,0,'',1,0,NULL,0,'','142','2022-07-28 10:41:11.492','2022-07-28 11:41:47.144',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go

/* Zestawy */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (102,1,10,3,NULL,5,NULL,'Domowa szarlotka z lodami','',18,18,18,18,NULL,NULL,0,0,'',1,0,NULL,1,'1','102','2022-07-27 13:24:57.149','2022-07-27 13:30:11.849',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (103,1,6,3,NULL,5,NULL,'Cappuccino','',15,15,15,15,NULL,NULL,0,0,'',1,0,NULL,0,'','103','2022-07-27 13:24:57.162','2022-07-27 13:30:11.859',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (104,1,6,3,NULL,5,NULL,'Coca Cola','',20,21,22,23,NULL,NULL,0,0,'',1,0,NULL,0,'','104','2022-07-27 13:24:57.173','2022-07-27 13:30:11.869',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (105,1,6,3,NULL,5,NULL,'Coca Cola Light','',20,30,40,50,NULL,NULL,0,0,'',1,0,NULL,0,'','105','2022-07-27 13:24:57.184','2022-07-27 13:30:11.879',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (106,1,6,3,NULL,5,NULL,'Coca Cola Zero','',6,6,6,6,NULL,NULL,0,0,'',1,0,NULL,0,'','106','2022-07-27 13:24:57.194','2022-07-27 13:30:11.889',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (107,1,6,3,NULL,5,NULL,'Fanta','',8,8,8,8,NULL,NULL,0,0,'',1,0,NULL,0,'','107','2022-07-27 13:24:57.204','2022-07-27 13:30:11.898',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (108,1,6,3,NULL,5,NULL,'Nestea','',8,8,8,8,NULL,NULL,0,0,'',1,0,NULL,0,'','108','2022-07-27 13:24:57.214','2022-07-27 13:30:11.909',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (109,1,6,3,NULL,5,NULL,'Herbata Ronnefeldt Leaf Cup','',10,10,10,10,NULL,NULL,0,0,'',1,0,NULL,0,'','109','2022-07-27 13:24:57.224','2022-07-27 13:30:11.919',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (131,1,12,3,NULL,5,NULL,'Szarlotka i napój w super cenie!','',17,17,17,17,NULL,NULL,0,6,'',1,0,NULL,0,'','132','2022-07-27 13:24:57.560','2022-07-27 13:30:12.216',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (133,1,12,3,NULL,5,NULL,'Trzecia cola za pół ceny','',1,1,1,1,NULL,NULL,0,6,'',1,0,NULL,0,'','134','2022-07-27 13:24:57.785','2022-07-27 13:30:12.270',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (140,1,12,3,NULL,5,NULL,'Zestaw obiadowy 1','',17,17,17,17,NULL,NULL,0,6,'',1,0,NULL,0,'','135','2022-07-27 13:30:12.276','2022-07-27 13:30:12.310',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (132,1,12,3,NULL,5,NULL,'Koszyk prezentów','',20,20,20,20,NULL,NULL,0,6,'',1,0,NULL,0,'','133','2022-07-27 13:24:57.660','2022-07-27 13:30:12.242',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (111,1,3,3,NULL,5,NULL,'Rosół gospodyni domowej','',15,15,15,15,NULL,NULL,0,0,'',1,0,NULL,1,'1','111','2022-07-27 13:24:57.250','2022-07-27 13:30:11.941',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (112,1,3,3,NULL,5,NULL,'Czerwony barszcz z kołdunami','',18,18,18,18,NULL,NULL,0,0,'',1,0,NULL,1,'1','112','2022-07-27 13:24:57.261','2022-07-27 13:53:07.132',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (113,1,3,3,NULL,5,NULL,'Sztandarowy Żur','',18,18,18,18,NULL,NULL,0,0,'',1,0,NULL,1,'1','113','2022-07-27 13:24:57.271','2022-07-27 13:30:11.961',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (114,1,3,3,NULL,5,NULL,'Golonka Ericha - nasz specjał!','',37,37,37,37,NULL,NULL,0,0,'',1,0,NULL,1,'1','114','2022-07-27 13:24:57.282','2022-07-27 13:30:11.971',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (115,1,3,3,NULL,5,NULL,'Bliny Wołodii z łososiem i kawiorem','',36,36,36,36,NULL,NULL,0,0,'',1,0,NULL,1,'1','115','2022-07-27 13:24:57.293','2022-07-27 13:30:11.982',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (116,1,3,3,0,5,NULL,'Frytki','',8,8,8,8,NULL,0,0,0,'',1,0,NULL,1,'1','116','2022-07-27 13:24:57.303','2022-07-28 11:04:44.802',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (117,1,3,3,NULL,5,NULL,'Ziemniaki po polsku','',8,8,8,8,NULL,NULL,0,0,'',1,0,NULL,1,'1','117','2022-07-27 13:24:57.313','2022-07-27 13:30:12.007',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (118,1,3,3,NULL,5,NULL,'Ziemniaki tłuczone','',7,7,7,7,NULL,NULL,0,0,'',1,0,NULL,1,'1','119','2022-07-27 13:24:57.324','2022-07-27 13:30:12.029',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (119,1,3,3,NULL,5,NULL,'Buraczki zasmażane','',7,7,7,7,NULL,NULL,0,0,'',1,0,NULL,1,'1','120','2022-07-27 13:24:57.334','2022-07-27 13:30:12.039',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go

/* Tandemy */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (110,1,6,3,1,5,NULL,'Piwo 0.5 z kaucją','',6.5,6.5,6.5,6.5,NULL,NULL,0,0,'',1,0,NULL,0,'','110','2022-07-27 13:24:57.238','2022-07-27 13:30:11.932',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (1,1,7,3,NULL,1,NULL,'Butelka 0.5','',0.5,0.5,0.5,0.5,NULL,NULL,0,1,'',1,0,NULL,0,'','1','2022-07-27 13:24:55.519','2022-07-27 13:30:10.406',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go

/* Usługi gastronomiczne */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (120,1,11,3,NULL,5,NULL,'Usł. gastron. 23%','',0,0,0,0,NULL,NULL,0,2,'',1,0,NULL,0,'','121','2022-07-27 13:24:57.343','2022-07-27 13:30:12.049',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (121,1,11,3,NULL,5,NULL,'Usł. katering. 23%','',0,0,0,0,NULL,NULL,0,2,'',1,0,NULL,0,'','122','2022-07-27 13:24:57.353','2022-07-27 13:30:12.060',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (122,1,11,3,NULL,4,NULL,'Usł. katering. 8%','',0,0,0,0,NULL,NULL,0,2,'',1,0,NULL,0,'','123','2022-07-27 13:24:57.364','2022-07-27 13:30:12.070',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go

/* Alkohole */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (123,1,1,3,NULL,5,NULL,'TATRA NP ZW Skrz. 20x500ml','',1.83,1.83,1.83,1.83,NULL,NULL,0,0,'',1,0,NULL,0,'','124','2022-07-27 13:24:57.378','2022-07-27 13:30:12.083',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (124,1,1,3,NULL,5,NULL,'TATRA JP ZW Skrz. 20x500ml 507a','',2.7,2.7,2.7,2.7,NULL,NULL,0,0,'',1,0,NULL,0,'','125','2022-07-27 13:24:57.393','2022-07-27 13:30:12.096',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (125,1,1,3,NULL,5,NULL,'ŻYWIEC Pusz. Zgrz. 6(4x500ml)','',2.73,2.73,2.73,2.73,NULL,NULL,0,0,'',1,0,NULL,0,'','126','2022-07-27 13:24:57.407','2022-07-27 13:30:12.109',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (126,1,1,3,NULL,5,NULL,'ŻYWIEC ZW Skrz. 20x500ml','',3.39,3.39,3.39,3.39,NULL,NULL,0,0,'',1,0,NULL,0,'','127','2022-07-27 13:24:57.424','2022-07-27 13:30:12.122',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (127,1,1,3,NULL,5,NULL,'ŻYWIEC ZW Skrz. 20x500ml','',64.41,64.41,64.41,64.41,NULL,NULL,0,0,'',1,0,NULL,0,'','128','2022-07-27 13:24:57.437','2022-07-27 13:30:12.136',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (128,1,1,3,NULL,5,NULL,'TATRA JP ZW Skrz. 20x500ml 507a','',51.3,51.3,51.3,51.3,NULL,NULL,0,0,'',1,0,NULL,0,'','129','2022-07-27 13:24:57.449','2022-07-27 13:30:12.150',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (129,1,1,3,NULL,5,NULL,'TATRA NP ZW Skrz. 20x500ml','',34.77,34.77,34.77,34.77,NULL,NULL,0,0,'',1,0,NULL,0,'','130','2022-07-27 13:24:57.461','2022-07-27 13:30:12.167',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment,GTU) VALUES (130,1,1,3,NULL,5,NULL,'ŻYWIEC Pusz. Zgrz. 6(4x500ml)','',4.17,4.17,4.17,4.17,NULL,NULL,0,0,'',1,0,NULL,0,'','131','2022-07-27 13:24:57.473','2022-07-27 13:30:12.183',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0,'');
go

/* Barcode */
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1021',1,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000147042',3,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2003',3,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5902078000102',4,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2004',4,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000000996',5,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2006',5,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000054227',6,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2005',6,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000006271',7,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2007',7,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901886010228',8,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2009',8,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901886010259',9,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2010',9,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000114099',10,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2012',10,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3700123303282',11,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2015',11,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497311014',12,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2016',12,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000050939',13,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2018',13,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900334000859',14,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2019',14,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900334012746',15,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2020',15,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900394003548',19,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2023',19,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8000500042854',20,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2024',20,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900862017886',21,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2025',21,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900951016219',22,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2026',22,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7613032546700',23,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2027',23,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5905784308760',24,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2028',24,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4011165098567',25,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2029',25,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5903232843562',26,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2030',26,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901480012246',27,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2031',27,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5906747308612',29,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2033',29,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901588016016',31,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2035',31,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009900412711',32,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2036',32,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009900437349',33,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2037',33,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2504',34,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5029053031255',34,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900788400137',36,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5004',36,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900839852861',37,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5005',37,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900571001282',38,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2038',38,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900320003420',39,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2039',39,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901588056029',40,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2040',40,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8594003840340',41,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5003',41,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901067455022',42,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5002',42,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900552039082',44,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2008',44,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900500024764',45,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2011',45,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900552042020',46,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2002',46,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('9002490100193',47,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2017',47,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('501',48,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('502',49,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('503',50,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('505',52,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1002',54,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1003',55,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1004',56,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1005',57,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1007',59,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1009',61,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1501',63,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8714789554679',63,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1503',64,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8718951031050',64,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1504',65,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901549987508',65,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2502',66,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5907542740003',66,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2503',67,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5029053037172',67,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1508',69,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8000700000005',69,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1502',70,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5201314048800',70,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1505',71,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('50220021',71,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1506',72,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8711600682764',72,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1507',73,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8712561845069',73,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1511',74,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('42236863',74,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1512',75,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7702018837830',75,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1513',76,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4005808729890',76,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1514',77,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900017304007',77,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1509',78,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4005808782390',78,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1510',79,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901887019732',79,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1515',80,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3838824085272',80,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2506',82,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8711600304741',82,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2507',83,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627030983',83,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2508',84,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627011128',84,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2509',85,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5000204746273',85,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2510',86,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901832490500',86,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2511',87,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900133006496',87,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2512',88,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5000204731934',88,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2513',89,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009175936776',89,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2515',91,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900133007905',91,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2516',92,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5720233358437',92,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2517',93,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4084500723351',93,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2518',94,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4084500702899',94,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2519',95,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('9000100258968',95,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2520',96,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8001480022713',96,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2521',97,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900536273723',97,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2522',98,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627059014',98,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2523',99,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8718951012264',99,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2524',100,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900931008982',100,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2525',101,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4000290939505',101,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1011',102,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1012',103,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1013',104,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1014',105,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1015',106,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1016',107,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1017',108,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1018',109,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1020',110,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1031',111,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1033',113,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1034',114,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1035',115,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1037',117,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1039',118,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1040',119,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4001',120,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4002',121,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4003',122,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559953760',123,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559830009',124,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559140009',125,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559130000',126,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699001829',127,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699001799',128,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699002604',129,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559146001',130,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3003',131,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3001',132,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3002',133,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3004',140,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1032',112,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1038',134,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5006',139,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5011',141,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7622300332150',17,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5906747308582',28,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900352006284',30,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1036',116,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901480001134',35,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('504',51,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1001',53,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1008',60,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1010',62,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5012',142,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5010',135,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5007',136,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5008',137,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5009',138,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497340335',2,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2001',2,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901067453028',16,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2013',16,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900394005528',18,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2022',18,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497012416',43,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2014',43,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1006',58,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2501',68,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900273472939',68,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2505',81,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627050547',81,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2514',90,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627047226',90,0,1,'',1,0,'');
go

/* ProductDescription */
/*INSERT INTO ProductDescription VALUES(101,0,0,'wypiekana z jabłek ogrodowych z dodatkiem soczystych brzoskwiń, podawana z kremowymi lodami waniliowymi');*/
/*go*/

/* GastroElement */
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (131,0,2,'Szarlotka',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (131,1,2,'Napój',1.99,1,0,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (132,0,0,'Produkty',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (133,0,2,'Pierwsze dwie',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (133,1,1,'Trzecia',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (140,0,2,'Danie główne',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (140,1,2,'Zupa',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (140,2,3,'Dodatki',3,1,0,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (140,3,3,'Napoje',0,1,1,0);
go

/* GastroElementList */
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,0,0,102,15,1,1,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,0,103,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,1,104,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,2,105,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,3,106,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,4,107,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,5,108,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (131,1,6,109,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (132,0,0,17,15.5,1,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (132,0,1,28,5.99,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (132,0,2,26,1.6,3,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (132,0,3,31,3.5,1,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (132,0,4,20,2.2,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,0,0,104,8,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,1,0,104,4,1,1,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,1,1,105,3.5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,1,2,106,3,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,1,3,6,2.25,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (133,1,4,5,1.2,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,0,0,115,36,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,0,1,114,37,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,1,0,112,18,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,1,1,111,15,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,2,0,116,8,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,2,1,117,8,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,2,2,118,7,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,2,3,134,6,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,3,0,104,5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,3,1,105,5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (140,3,2,109,4,1,0,0);
go

/* GastroTransition */
INSERT INTO GastroTransition (VatRateId,ProductId,Type) VALUES (5,120,0);
go
INSERT INTO GastroTransition (VatRateId,ProductId,Type) VALUES (4,122,1);
go
INSERT INTO GastroTransition (VatRateId,ProductId,Type) VALUES (5,121,1);
go

/* CustomerCardFormat */
INSERT INTO CustomerCardFormat (CustomerCardFormatId,IsActive,Name,CodeLength,PrefixLength,PrefixPosition,YearLength,CustomerCodeLength,CustomerCodePosition,DatePosition,DiscountIdPosition,Prefix,IsExpireDate,IsMonth,IsControlDigit,IsAutoRecognize,ExternalId,Creation,LastUpdate) VALUES (1,1,'Karta rabatowa',13,3,1,2,6,6,4,12,'201',1,0,1,1,'1','2022-07-27 13:24:38.513','2022-07-29 09:33:14.129');
go

/* DiscountDefined */
INSERT INTO DiscountDefined (DiscountDefinedId,IsActive,Type,Name,Purpose,DateFrom,DateTo,Days,Hours,DefaultValue,MaxValue,IsEditable,IsObligatory,IsPriceModify,RestrictionType,PurchaseValueFrom,PurchaseValueTo,ProductGroupId,Creation,LastUpdate,ExternalId) VALUES (1,1,1,'Rabat 10%',2,'2022-07-27 13:24:32.881','2022-07-27 13:24:32.881','','',10,0,0,0,0,1,0,0,0,'2022-07-27 13:24:57.908','2022-07-27 13:24:57.908','1');
go
INSERT INTO DiscountDefined (DiscountDefinedId,IsActive,Type,Name,Purpose,DateFrom,DateTo,Days,Hours,DefaultValue,MaxValue,IsEditable,IsObligatory,IsPriceModify,RestrictionType,PurchaseValueFrom,PurchaseValueTo,ProductGroupId,Creation,LastUpdate,ExternalId) VALUES (2,1,1,'Rabat na pozycję 5%',1,'2022-07-29 09:33:13.005','2022-07-29 09:33:13.005','','',5,0,0,0,0,1,0,0,0,'2022-07-27 13:24:57.958','2022-07-29 09:33:14.772','2');
go

/* DiscountLevel */
/* Rabaty są inicjalizowane w TDiscountLevelList -> metoda initializeDiscountLevelTable(IDatabase _db)
 zatem ustawiam je bezpośrednio w kodzie. Tutaj mógłbym co najwyżej wykonać 'Update' a nie 'Insert'
 ponieważ metoda dokonuje inicjalizcji i wstawienia wartości.
 */

/* Phrase */
INSERT INTO Phrase (PhraseId,IsActive,Type,Text,PriceLevel,ExternalId,Creation,LastUpdate) VALUES (1,1,3,'Towar uszkodzony',1,'1','2022-07-27 13:32:34.700','2022-07-27 13:32:34.700');
go
INSERT INTO Phrase (PhraseId,IsActive,Type,Text,PriceLevel,ExternalId,Creation,LastUpdate) VALUES (2,1,3,'Dla szefa',1,'2','2022-07-28 11:41:44.503','2022-07-28 11:41:44.503');
go
INSERT INTO Phrase (PhraseId,IsActive,Type,Text,PriceLevel,ExternalId,Creation,LastUpdate) VALUES (3,1,3,'Towar wydano dnia:',1,'3','2022-07-28 11:41:44.512','2022-07-28 11:41:44.512');
go
INSERT INTO Phrase (PhraseId,IsActive,Type,Text,PriceLevel,ExternalId,Creation,LastUpdate) VALUES (4,1,3,'Zaliczka na zakup towaru',1,'4','2022-07-28 11:41:44.520','2022-07-28 11:41:44.520');
go

/* BarcodeFormat */
INSERT INTO BarcodeFormat (BarcodeFormatId,IsActive,Name,Prefix,NumberLength,PluGroupIdentifier,PriceVerifier,WeighedInterpretation,WeighedPrecision,ExternalId,Creation,LastUpdate) VALUES (1,1,'Waga 1','21',3,0,0,0,3,'','2022-08-26 07:27:37.047','2022-08-26 07:27:37.047');
go