/*==========================================================================*/
/* Skrypt wpisujący dane demo do bazy mPOS-a SQLite dla wersji angielskiej  */
/*                                                                          */
/* Insoft luty 2015 LS                                                      */
/*==========================================================================*/

/* Informacja o tym, że baza nie jest pusta */
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'IsDatabaseEmpty', 0, '1', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'DatabaseType', 0, 'demo', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* PosGroup */
INSERT INTO PosGroup (PosGroupId, Name, IsActive, Creation, LastUpdate) VALUES (1, 'Liniowe', 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Pos */
INSERT INTO Pos (PosId, PosGroupId, type, Name, Number, IsActive, Creation, LastUpdate) VALUES (1, 1, 0, '1', 1, 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* OperatorProfile */
/* Profile nie mogą być usuwane podczas czyszczenia bazy więc ponowne wypełnienie bazy danymi demo stanowiłoby w tym miejscu problem.
 * Profile są insertowane w kodzie w TSQLLAndroPosOpenHelper.insertOperatorProfiles()
 */
/*INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (1, 0, 'Cashier', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (2, 1, 'Supervisor', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (3, 2, 'Manager', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (4, 3, 'Service', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
*/
/* Currency */
INSERT INTO Currency VALUES(3,1,'£','GBP',1,1,1,1,'2015-02-02 14:43:14.683','2015-02-02 14:54:47.475');
go
INSERT INTO Currency VALUES(4,1,'€','EUR',0.7523,1,0,2,'2015-02-02 14:47:31.760','2015-02-02 14:55:28.757');
go

/* ShopInfo */
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'name', 0, 'Things&Stuff', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'bankaccount', 0, '0123456789', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'bankname', 0, 'BankOfEngland', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'city', 0, 'London', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'street', 0, 'Baker Street 221B', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'nip', 0, '0123456789', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'phonenumber', 0, '0123456789', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('DaneSklepu', 'zipcode', 0, '38200', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* PaymentForm */
INSERT INTO PaymentForm VALUES(4,1,'Cash',0,'',1,1,'2015-02-02 14:43:14.735','2015-02-02 14:53:36.930');
go
INSERT INTO PaymentForm VALUES(5,1,'Debit card',2,'',0,'','2015-02-02 14:54:07.238','2015-02-02 14:54:07.238');
go
INSERT INTO PaymentForm VALUES(6,1,'Sodexho',4,'',0,'','2015-02-02 14:54:23.309','2015-02-02 14:54:23.309');
go

/* Operator */
INSERT INTO Operator VALUES(4,1,NULL,1,1,'Max','Paine','','',2,0,035196204205086126207186,'mp',0,NULL,NULL,'2015-02-02 14:47:31.533','2015-02-02 14:57:40.348');
go
INSERT INTO Operator VALUES(5,1,NULL,1,2,'Mathilda','Pilkington','','',3,0,222225075016179166080159,'mi',0,NULL,NULL,'2015-02-02 14:47:31.601','2015-02-02 14:57:26.275');
go
INSERT INTO Operator VALUES(6,1,NULL,1,3,'Parker','Bowles','','',NULL,NULL,015074068122080227156018,'pb',0,NULL,NULL,'2015-02-02 14:57:02.765','2015-02-02 14:57:02.765');
go
INSERT INTO Operator VALUES(7,4,NULL,1,4,'Alan','Wake','','',NULL,NULL,018058122209207000236241,'aw',0,NULL,NULL,'2015-02-02 14:58:07.002','2015-02-02 14:58:07.002');
go

/* Customer */
INSERT INTO Customer (CustomerId, IsActive, Name, Nip, Phone, Email, IsRetailCustomer, IsCustomer, IsManufacturer, IsSupplier, IsShop, IsCentralStore, Creation, LastUpdate)
VALUES (1, 1, 'John Smith', 2847103952, '492-239-941', 'j.smith@mail.com', 1, 0, 0, 0, 0, 0, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Customer (CustomerId, IsActive, Name, Nip, Phone, Email, IsRetailCustomer, IsCustomer, IsManufacturer, IsSupplier, IsShop, IsCentralStore, Creation, LastUpdate)
VALUES (2, 1, 'Ryan Murphy', 3928727402, '592-283-358', 'r.murphy@mail.com', 1, 0, 0, 0, 0, 0, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Customer (CustomerId, IsActive, Name, Nip, Phone, Email, IsRetailCustomer, IsCustomer, IsManufacturer, IsSupplier, IsShop, IsCentralStore, Creation, LastUpdate)
VALUES (3, 1, 'Emily Black', 7958206981, '591-959-292', 'e.black@mail.com', 1, 0, 0, 0, 0, 0, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* ProductGroup */
INSERT INTO ProductGroup VALUES(23,1,'Jackets',NULL,NULL,0,0,0,1,'2015-02-02 14:43:14.778','2015-02-02 14:47:32.223',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(24,1,'Other',NULL,NULL,0,0,0,2,'2015-02-02 14:43:14.813','2015-02-02 14:47:32.312',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(25,1,'Trousers',NULL,NULL,0,0,0,3,'2015-02-02 14:43:14.846','2015-02-02 14:47:32.387',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(26,1,'Shirts',NULL,NULL,0,0,0,4,'2015-02-02 14:43:14.879','2015-02-02 14:47:32.485',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(27,1,'Skirts',NULL,NULL,0,0,0,5,'2015-02-02 14:43:14.911','2015-02-02 14:47:32.588',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(28,1,'Shorts',NULL,NULL,0,0,0,6,'2015-02-02 14:43:14.941','2015-02-02 14:47:32.619',0,0,0,0);
go
INSERT INTO ProductGroup VALUES(29,1,'Sweaters',NULL,NULL,0,0,0,7,'2015-02-02 14:43:14.975','2015-02-02 14:47:32.646',0,0,0,0);
go

/* ProductGroupTree */
/* --- na razie brak powiązań --- */

/* VatRate */
INSERT INTO VatRate VALUES(10,1,-1,-1,'2015-02-02 14:43:14.341','2015-02-02 14:47:30.950');
go
INSERT INTO VatRate VALUES(11,1,0,0,'2015-02-02 14:43:14.381','2015-02-02 14:47:31.044');
go
INSERT INTO VatRate VALUES(14,1,2200,2200,'2015-02-02 14:43:14.479','2015-02-02 14:47:31.208');
go

/* UnitName */
INSERT INTO UnitName VALUES(7,1,'pcs',0,1,'2015-02-02 14:43:14.550','2015-02-02 14:52:48.913');
go
INSERT INTO UnitName VALUES(8,1,'kg',-3,2,'2015-02-02 14:43:14.579','2015-02-02 14:47:31.346');
go
INSERT INTO UnitName VALUES(9,1,'pack',0,3,'2015-02-02 14:43:14.611','2015-02-02 14:52:39.772');
go

/* Product */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1302,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 48','16A WOM TRO',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,1,'2015-02-02 14:43:21.229','2015-02-02 14:47:38.914',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1303,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER HS XS','36A V NEC WO',13.15,11.18,15.78,19.73,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,2,'2015-02-02 14:43:21.302','2015-02-02 14:47:39.019',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1304,1,29,7,NULL,14,NULL,'BUTTONED SWEAT. L/S L','16A BUT SWE',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,3,'2015-02-02 14:43:21.373','2015-02-02 14:47:39.128',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1305,1,29,7,NULL,14,NULL,'BUTTONED SWEAT. L/S M','16A BUT SW 1',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,4,'2015-02-02 14:43:21.467','2015-02-02 14:47:39.249',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1306,1,29,7,NULL,14,NULL,'BUTTONED SWEAT. L/S S','16A BUT SW 2',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,5,'2015-02-02 14:43:21.575','2015-02-02 14:47:39.546',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1307,1,29,7,NULL,14,NULL,'ROUND NECK SWEAT.L/S L','16A ROU NEC',12.26,10.42,14.71,18.39,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,6,'2015-02-02 14:43:21.738','2015-02-02 14:47:39.891',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1308,1,29,7,NULL,14,NULL,'ROUND NECK SWEAT.L/S M','16A ROU NE 1',12.26,10.42,14.71,18.39,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,7,'2015-02-02 14:43:21.840','2015-02-02 14:47:40.028',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1309,1,29,7,NULL,14,NULL,'ROUND NECK SWEAT.L/S S','16A ROU NE 2',12.26,10.42,14.71,18.39,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,8,'2015-02-02 14:43:21.942','2015-02-02 14:47:40.224',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1310,1,29,7,NULL,14,NULL,'TURTLE NECK SWEATER L','16A TUR NEC',16.02,13.62,19.22,24.03,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,9,'2015-02-02 14:43:22.039','2015-02-02 14:47:40.349',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1311,1,29,7,NULL,14,NULL,'TURTLE NECK SWEATER M','16A TUR NE 1',16.02,13.62,19.22,24.03,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,10,'2015-02-02 14:43:22.136','2015-02-02 14:47:40.472',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1312,1,29,7,NULL,14,NULL,'TURTLE NECK SWEATER S','16A TUR NE 2',16.02,13.62,19.22,24.03,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,11,'2015-02-02 14:43:22.257','2015-02-02 14:47:40.615',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1313,1,24,7,NULL,14,NULL,'PULLOVER L/S L','16A PUL LS L',14.24,12.1,17.09,21.36,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,12,'2015-02-02 14:43:22.378','2015-02-02 14:47:40.759',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1314,1,24,7,NULL,14,NULL,'PULLOVER L/S M','16A PUL LS M',14.24,12.1,17.09,21.36,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,13,'2015-02-02 14:43:22.493','2015-02-02 14:47:40.910',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1315,1,24,7,NULL,14,NULL,'PULLOVER L/S S','16A PUL LS S',14.24,12.1,17.09,21.36,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,14,'2015-02-02 14:43:22.562','2015-02-02 14:47:41.049',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1316,1,29,7,NULL,14,NULL,'CARDIGAN SWEATER L/S L','16A CAR SWE',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,15,'2015-02-02 14:43:22.633','2015-02-02 14:47:41.190',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1317,1,29,7,NULL,14,NULL,'CARDIGAN SWEATER L/S M','16A CAR SW 1',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,16,'2015-02-02 14:43:22.709','2015-02-02 14:47:41.340',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1318,1,29,7,NULL,14,NULL,'CARDIGAN SWEATER L/S S','16A CAR SW 2',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,17,'2015-02-02 14:43:22.793','2015-02-02 14:47:41.500',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1319,1,23,7,NULL,14,NULL,'WOMAN JACKET 38','16A WOM JAC',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,18,'2015-02-02 14:43:22.872','2015-02-02 14:47:41.622',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1320,1,23,7,NULL,14,NULL,'WOMAN JACKET 40','16A WOM JA 1',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,19,'2015-02-02 14:43:22.953','2015-02-02 14:47:41.741',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1321,1,23,7,NULL,14,NULL,'WOMAN JACKET 42','16A WOM JA 2',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,20,'2015-02-02 14:43:23.056','2015-02-02 14:47:41.860',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1322,1,23,7,NULL,14,NULL,'WOMAN JACKET 44','16A WOM JA 3',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,21,'2015-02-02 14:43:23.160','2015-02-02 14:47:42.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1323,1,23,7,NULL,14,NULL,'WOMAN JACKET 46','16A WOM JA 4',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,22,'2015-02-02 14:43:23.266','2015-02-02 14:47:42.142',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1324,1,23,7,NULL,14,NULL,'WOMAN JACKET 48','16A WOM JA 5',39.16,33.29,46.99,58.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,23,'2015-02-02 14:43:23.365','2015-02-02 14:47:42.293',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1325,1,24,7,NULL,14,NULL,'WOMAN COAT 38','16A WOM COA',41.84,35.56,50.21,62.76,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,24,'2015-02-02 14:43:23.475','2015-02-02 14:47:42.437',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1326,1,24,7,NULL,14,NULL,'WOMAN COAT 40','16A WOM CO 1',41.84,35.56,50.21,62.76,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,25,'2015-02-02 14:43:23.547','2015-02-02 14:47:42.625',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1327,1,24,7,NULL,14,NULL,'WOMAN COAT 42','16A WOM CO 2',41.84,35.56,50.21,62.76,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,26,'2015-02-02 14:43:23.618','2015-02-02 14:47:42.769',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1328,1,24,7,NULL,14,NULL,'WOMAN COAT 44','16A WOM CO 3',41.84,35.56,50.21,62.76,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,27,'2015-02-02 14:43:23.705','2015-02-02 14:47:42.912',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1329,1,24,7,NULL,14,NULL,'WOMAN COAT 46','16A WOM CO 4',41.84,35.56,50.21,62.76,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,28,'2015-02-02 14:43:23.793','2015-02-02 14:47:43.057',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1330,1,24,7,NULL,14,NULL,'WOMAN COAT 48','16A WOM CO 5',36.1,30.69,43.32,54.15,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,29,'2015-02-02 14:43:23.864','2015-02-02 14:47:43.240',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1331,1,27,7,NULL,14,NULL,'WOMAN SKIRT 38','16A WOM SKI',12.96,11.02,15.55,19.44,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,30,'2015-02-02 14:43:23.934','2015-02-02 14:47:43.428',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1332,1,27,7,NULL,14,NULL,'WOMAN SKIRT 40','16A WOM SK 1',12.96,11.02,15.55,19.44,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,31,'2015-02-02 14:43:24.022','2015-02-02 14:47:43.628',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1333,1,27,7,NULL,14,NULL,'WOMAN SKIRT 42','16A WOM SK 2',12.96,11.02,15.55,19.44,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,32,'2015-02-02 14:43:24.116','2015-02-02 14:47:43.826',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1334,1,27,7,NULL,14,NULL,'WOMAN SKIRT 44','16A WOM SK 3',12.96,11.02,15.55,19.44,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,33,'2015-02-02 14:43:24.217','2015-02-02 14:47:44.011',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1335,1,27,7,NULL,14,NULL,'WOMAN SKIRT 46','16A WOM SK 4',12.96,11.02,15.55,19.44,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,34,'2015-02-02 14:43:24.322','2015-02-02 14:47:44.165',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1336,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 38','16A WOM TR 1',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,35,'2015-02-02 14:43:24.423','2015-02-02 14:47:44.314',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1337,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 40','16A WOM TR 2',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,36,'2015-02-02 14:43:24.533','2015-02-02 14:47:44.474',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1338,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 42','16A WOM TR 3',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,37,'2015-02-02 14:43:24.646','2015-02-02 14:47:44.637',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1339,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 44','16A WOM TR 4',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,38,'2015-02-02 14:43:24.764','2015-02-02 14:47:45.259',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1340,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 46','16A WOM TR 5',21.26,18.07,25.51,31.89,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,39,'2015-02-02 14:43:24.838','2015-02-02 14:47:45.784',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1341,1,27,7,NULL,14,NULL,'WOMAN SKIRT 48','16A WOM SK 5',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,40,'2015-02-02 14:43:24.909','2015-02-02 14:47:45.906',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1342,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 26','16A WOM TR 6',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,41,'2015-02-02 14:43:24.978','2015-02-02 14:47:46.022',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1343,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 27','16A WOM TR 7',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,42,'2015-02-02 14:43:25.047','2015-02-02 14:47:46.131',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1344,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 28','16A WOM TR 8',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,43,'2015-02-02 14:43:25.119','2015-02-02 14:47:46.241',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1345,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 29','16A WOM TR 9',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,44,'2015-02-02 14:43:25.188','2015-02-02 14:47:46.353',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1346,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 30','16A WOM T 10',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,45,'2015-02-02 14:43:25.257','2015-02-02 14:47:46.466',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1347,1,25,7,NULL,14,NULL,'WOMAN TROUSERS 31','16A WOM T 11',20.97,17.82,25.16,31.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,46,'2015-02-02 14:43:25.327','2015-02-02 14:47:46.573',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1348,1,26,7,NULL,14,NULL,'L/S WOMEN SHIRT L','16A LS WOM S',7.52,6.39,9.02,11.28,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,47,'2015-02-02 14:43:25.396','2015-02-02 14:47:46.673',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1349,1,26,7,NULL,14,NULL,'L/S WOMEN SHIRT M','16A LS WOM 1',7.52,6.39,9.02,11.28,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,48,'2015-02-02 14:43:25.471','2015-02-02 14:47:46.773',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1350,1,26,7,NULL,14,NULL,'L/S WOMEN SHIRT S','16A LS WOM 2',7.52,6.39,9.02,11.28,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,49,'2015-02-02 14:43:25.555','2015-02-02 14:47:46.883',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1351,1,26,7,NULL,14,NULL,'L/S WOMEN SHIRT XS','16A LS WOM 3',7.52,6.39,9.02,11.28,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,50,'2015-02-02 14:43:25.624','2015-02-02 14:47:46.987',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1352,1,24,7,NULL,14,NULL,'BAG ST','16A BAG ST 7',7.52,6.39,9.02,11.28,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,51,'2015-02-02 14:43:25.694','2015-02-02 14:47:47.090',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1353,1,24,7,NULL,14,NULL,'SCARF ST','16A SCA ST 2',11.77,10,14.12,17.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,52,'2015-02-02 14:43:25.763','2015-02-02 14:47:47.215',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1354,1,24,7,NULL,14,NULL,'BOOT 36','16A BOO 36 7',54.49,46.32,65.39,81.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,53,'2015-02-02 14:43:25.832','2015-02-02 14:47:47.330',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1355,1,24,7,NULL,14,NULL,'BOOT 37','16A BOO 37 7',54.49,46.32,65.39,81.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,54,'2015-02-02 14:43:25.903','2015-02-02 14:47:47.445',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1356,1,24,7,NULL,14,NULL,'BOOT 38','16A BOO 38 7',54.49,46.32,65.39,81.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,55,'2015-02-02 14:43:25.990','2015-02-02 14:47:47.583',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1357,1,24,7,NULL,14,NULL,'BOOT 39','16A BOO 39 7',54.49,46.32,65.39,81.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,56,'2015-02-02 14:43:26.058','2015-02-02 14:47:47.703',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1358,1,24,7,NULL,14,NULL,'POSTER ST','16A POS ST 0',79.12,67.25,94.94,118.68,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,57,'2015-02-02 14:43:26.128','2015-02-02 14:47:47.850',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1359,1,29,7,NULL,14,NULL,'WOMAN ROUND NECK SW. L','16A WOM ROU',7.02,5.97,8.42,10.53,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,58,'2015-02-02 14:43:26.198','2015-02-02 14:47:47.967',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1360,1,29,7,NULL,14,NULL,'WOMAN ROUND NECK SW. M','16A WOM RO 1',7.02,5.97,8.42,10.53,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,59,'2015-02-02 14:43:26.284','2015-02-02 14:47:48.122',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1361,1,29,7,NULL,14,NULL,'WOMAN ROUND NECK SW. S','16A WOM RO 2',7.02,5.97,8.42,10.53,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,60,'2015-02-02 14:43:26.356','2015-02-02 14:47:48.236',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1362,1,29,7,NULL,14,NULL,'WOMAN ROUND NECK SW. XS','16A WOM RO 3',7.02,5.97,8.42,10.53,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,61,'2015-02-02 14:43:26.428','2015-02-02 14:47:48.344',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1363,1,24,7,NULL,14,NULL,'WOMAN TANK TOP L','16I WOM TAN',11.77,10,14.12,17.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,62,'2015-02-02 14:43:26.503','2015-02-02 14:47:48.460',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1364,1,24,7,NULL,14,NULL,'WOMAN TANK TOP M','16I WOM TA 1',11.77,10,14.12,17.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,63,'2015-02-02 14:43:26.574','2015-02-02 14:47:48.574',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1365,1,24,7,NULL,14,NULL,'WOMAN TANK TOP S','16I WOM TA 2',11.77,10,14.12,17.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,64,'2015-02-02 14:43:26.646','2015-02-02 14:47:48.727',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1366,1,24,7,NULL,14,NULL,'WOMAN TANK TOP XS','16I WOM TA 3',11.77,10,14.12,17.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,65,'2015-02-02 14:43:26.717','2015-02-02 14:47:48.876',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1367,1,26,7,NULL,14,NULL,'WOMAN SHIRT L','16I WOM SHI',15.03,12.78,18.040001,22.540001,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,66,'2015-02-02 14:43:26.790','2015-02-02 15:04:56.131',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1368,1,26,7,NULL,14,NULL,'WOMAN SHIRT M','16I WOM SH 1',15.03,12.78,18.040001,22.540001,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,67,'2015-02-02 14:43:26.888','2015-02-02 15:04:59.114',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1369,1,26,7,NULL,14,NULL,'WOMAN SHIRT S','16I WOM SH 2',15.03,12.78,18.040001,22.540001,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,68,'2015-02-02 14:43:26.987','2015-02-02 15:05:02.081',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1370,1,26,7,NULL,14,NULL,'WOMAN SHIRT XS','16I WOM SH 3',15.03,12.78,18.040001,22.540001,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,69,'2015-02-02 14:43:27.088','2015-02-02 15:05:04.966',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1371,1,24,7,NULL,14,NULL,'PULLOVER L/S XS','36A PUL LS X',11.28,9.59,13.54,16.92,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,70,'2015-02-02 14:43:27.193','2015-02-02 14:47:49.577',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1372,1,24,7,NULL,14,NULL,'KNITTED CAPE L','36A KNI CAP',21.66,18.41,25.99,32.49,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,71,'2015-02-02 14:43:27.299','2015-02-02 14:47:49.680',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1373,1,24,7,NULL,14,NULL,'KNITTED CAPE M','36A KNI CA 1',21.66,18.41,25.99,32.49,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,72,'2015-02-02 14:43:27.371','2015-02-02 14:47:49.785',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1374,1,24,7,NULL,14,NULL,'KNITTED CAPE S','36A KNI CA 2',21.66,18.41,25.99,32.49,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,73,'2015-02-02 14:43:27.443','2015-02-02 14:47:49.890',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1375,1,24,7,NULL,14,NULL,'KNITTED COAT L','36A KNI COA',26.31,22.36,31.57,39.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,74,'2015-02-02 14:43:27.517','2015-02-02 14:47:49.985',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1376,1,24,7,NULL,14,NULL,'KNITTED COAT M','36A KNI CO 1',26.31,22.36,31.57,39.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,75,'2015-02-02 14:43:27.588','2015-02-02 14:47:50.096',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1377,1,24,7,NULL,14,NULL,'KNITTED COAT S','36A KNI CO 2',26.31,22.36,31.57,39.46,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,76,'2015-02-02 14:43:27.658','2015-02-02 14:47:50.220',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1378,1,29,7,NULL,14,NULL,'L/S WOMAN SWEATER L','36A LS WOM S',13.15,11.18,15.78,19.73,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,77,'2015-02-02 14:43:27.729','2015-02-02 14:47:50.345',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1379,1,29,7,NULL,14,NULL,'L/S WOMAN SWEATER M','36A LS WOM 1',13.15,11.18,15.78,19.73,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,78,'2015-02-02 14:43:27.801','2015-02-02 14:47:50.463',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1380,1,29,7,NULL,14,NULL,'L/S WOMAN SWEATER S','36A LS WOM 2',13.15,11.18,15.78,19.73,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,79,'2015-02-02 14:43:27.869','2015-02-02 14:47:50.578',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1381,1,29,7,NULL,14,NULL,'L/S WOMAN SWEATER XS','36A LS WOM 3',13.15,11.18,15.78,19.73,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,80,'2015-02-02 14:43:27.941','2015-02-02 14:47:50.706',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1382,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER HS L','36A V NEC 1',10.88,9.25,13.06,16.32,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,81,'2015-02-02 14:43:28.014','2015-02-02 14:47:50.801',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1383,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER HS M','36A V NEC 2',10.88,9.25,13.06,16.32,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,82,'2015-02-02 14:43:28.102','2015-02-02 14:47:50.895',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1384,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER HS S','36A V NEC 3',10.88,9.25,13.06,16.32,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,83,'2015-02-02 14:43:28.173','2015-02-02 14:47:50.993',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1385,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER LS L','36A V NEC 4',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,84,'2015-02-02 14:43:28.245','2015-02-02 14:47:51.088',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1386,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER LS M','36A V NEC 5',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,85,'2015-02-02 14:43:28.321','2015-02-02 14:47:51.188',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1387,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER LS S','36A V NEC 6',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,86,'2015-02-02 14:43:28.392','2015-02-02 14:47:51.286',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1388,1,29,7,NULL,14,NULL,'V NECK WO.SWEATER LS XS','36A V NEC 7',15.03,12.78,18.04,22.54,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,87,'2015-02-02 14:43:28.463','2015-02-02 14:47:51.384',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1389,1,28,7,NULL,14,NULL,'WOMAN SHORTS 38','36A WOM SHO',14.44,12.27,17.33,21.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,88,'2015-02-02 14:43:28.531','2015-02-02 14:47:51.482',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1390,1,28,7,NULL,14,NULL,'WOMAN SHORTS 40','36A WOM SH 1',14.44,12.27,17.33,21.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,89,'2015-02-02 14:43:28.601','2015-02-02 14:47:51.588',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1391,1,28,7,NULL,14,NULL,'WOMAN SHORTS 42','36A WOM SH 2',14.44,12.27,17.33,21.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,90,'2015-02-02 14:43:28.671','2015-02-02 14:47:51.698',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1392,1,28,7,NULL,14,NULL,'WOMAN SHORTS 44','36A WOM SH 3',14.44,12.27,17.33,21.66,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,91,'2015-02-02 14:43:28.741','2015-02-02 14:47:51.801',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1393,1,24,7,NULL,14,NULL,'GLOVES L','36A GLO L 70',8.7,7.39,10.44,13.05,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,92,'2015-02-02 14:43:28.833','2015-02-02 14:47:51.915',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1394,1,24,7,NULL,14,NULL,'GLOVES M','36A GLO M 70',8.7,7.39,10.44,13.05,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,93,'2015-02-02 14:43:28.951','2015-02-02 15:05:47.603',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1395,1,24,7,NULL,14,NULL,'GLOVES S','36A GLO S 70',8.7,7.39,10.44,13.05,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,94,'2015-02-02 14:43:29.049','2015-02-02 14:47:52.149',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1396,1,24,7,NULL,14,NULL,'BELT L','36A BEL L 70',7.32,6.22,8.78,10.98,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,95,'2015-02-02 14:43:29.148','2015-02-02 14:47:52.311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1397,1,24,7,NULL,14,NULL,'BELT M','36A BEL M 70',7.32,6.22,8.78,10.98,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,96,'2015-02-02 14:43:29.244','2015-02-02 14:47:52.426',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1398,1,24,7,NULL,14,NULL,'BELT S','36A BEL S 70',7.32,6.22,8.78,10.98,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,97,'2015-02-02 14:43:29.333','2015-02-02 14:47:52.528',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1399,1,24,7,NULL,14,NULL,'NECKLACE ST','36A NEC ST 9',10.58,8.99,12.7,15.87,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,98,'2015-02-02 14:43:29.424','2015-02-02 14:47:52.633',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1400,1,24,7,NULL,14,NULL,'PROMOTIONAL MATERIAL ST','36A PRO MAT',74.18,63.05,89.02,111.27,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,99,'2015-02-02 14:43:29.522','2015-02-02 14:47:52.740',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1401,1,29,7,NULL,14,NULL,'L/S W.T/NECK SWEATER L','36I LS WTN S',18.49,15.72,22.19,27.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,100,'2015-02-02 14:43:29.615','2015-02-02 14:47:52.838',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1402,1,29,7,NULL,14,NULL,'L/S W.T/NECK SWEATER M','36I LS WTN 1',18.49,15.72,22.19,27.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,101,'2015-02-02 14:43:29.712','2015-02-02 14:47:52.946',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1403,1,29,7,NULL,14,NULL,'L/S W.T/NECK SWEATER S','36I LS WTN 2',18.49,15.72,22.19,27.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,102,'2015-02-02 14:43:29.807','2015-02-02 14:47:53.044',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1404,1,29,7,NULL,14,NULL,'L/S W.T/NECK SWEATER XS','36I LS WTN 3',18.49,15.72,22.19,27.74,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,103,'2015-02-02 14:43:29.905','2015-02-02 14:47:53.145',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1405,1,24,7,NULL,14,NULL,'L/S WOMAN DRESS L','36I LS WOM D',25.81,21.94,30.97,38.71,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,104,'2015-02-02 14:43:30.027','2015-02-02 14:47:53.244',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1406,1,24,7,NULL,14,NULL,'L/S WOMAN DRESS M','36I LS WOM 1',25.81,21.94,30.97,38.71,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,105,'2015-02-02 14:43:30.124','2015-02-02 14:47:53.339',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1407,1,24,7,NULL,14,NULL,'L/S WOMAN DRESS S','36I LS WOM 2',25.81,21.94,30.97,38.71,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,106,'2015-02-02 14:43:30.220','2015-02-02 14:47:53.437',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(1408,1,24,7,NULL,14,NULL,'L/S WOMAN DRESS XS','36I LS WOM 3',25.81,21.94,30.97,38.71,NULL,NULL,NULL,0,NULL,0,NULL,NULL,0,107,'2015-02-02 14:43:30.320','2015-02-02 14:47:53.571',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go

/* Barcode */
INSERT INTO Barcode VALUES(1,1302,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(2,1303,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(3,1304,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(4,1305,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(5,1306,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(6,1307,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(7,1308,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8,1309,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(9,1310,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(10,1311,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(101,1312,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(102,1313,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(103,1314,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(104,1315,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(105,1316,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(106,1317,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(107,1318,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(108,1319,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(109,1320,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(110,1321,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1001,1322,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1002,1323,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1003,1324,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1004,1325,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1005,1326,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1006,1327,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1007,1328,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1008,1329,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1009,1330,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(1010,1331,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073983668,1332,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073983675,1333,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073983682,1334,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073983699,1335,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073510574,1336,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073510581,1337,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073510598,1338,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073510604,1339,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073510611,1340,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073488347,1341,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566939,1342,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566946,1343,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566953,1344,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566960,1345,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566977,1346,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073566984,1347,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073233916,1348,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073233909,1349,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073233893,1350,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073233886,1351,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073744153,1352,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073773498,1353,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073857082,1354,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073857099,1355,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073857105,1356,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073857112,1357,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152209528,1358,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073381389,1359,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073381372,1360,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073381365,1361,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073381358,1362,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152028631,1363,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152028624,1364,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152028617,1365,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152028600,1366,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074235216,1371,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073802037,1372,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073802020,1373,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073802013,1374,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073804178,1375,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073804161,1376,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073804154,1377,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073911340,1378,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073911333,1379,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073911326,1380,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073911319,1381,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073918769,1382,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073918752,1383,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073918745,1384,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919568,1385,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919551,1386,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919544,1387,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919537,1388,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073925552,1389,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073925569,1390,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073925576,1391,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073925583,1392,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074191215,1393,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074191192,1395,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074191468,1396,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074191451,1397,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074191444,1398,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033074193042,1399,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033152209641,1400,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919926,1401,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919919,1402,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919902,1403,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073919896,1404,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073922988,1405,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073922971,1406,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073922964,1407,1,1,'',1,0,'',0);
go
INSERT INTO Barcode VALUES(8033073922957,1408,1,1,'',1,0,'',0);
go

/* CustomerCardFormat */
INSERT INTO CustomerCardFormat (CustomerCardFormatId, IsActive, Name, CodeLength, PrefixLength, PrefixPosition, YearLength, CustomerCodeLength, CustomerCodePosition, DatePosition, DiscountIdPosition, Prefix, IsExpireDate, IsMonth, IsControlDigit, IsAutoRecognize, ExternalId, Creation, LastUpdate) VALUES (1, 1, 'Discount card', 13, 3, 1, 2, 6, 6, 4, 12, '201', 1, 0, 1, 1, '', '2017-08-30 12:28:20.802', '2017-08-30 12:28:20.802');
GO

/* DiscountDefined */
INSERT INTO DiscountDefined (DiscountDefinedId, IsActive, Type, Name, Purpose, DateFrom, DateTo, Days, Hours, DefaultValue, MaxValue, IsEditable, IsObligatory, IsPriceModify, RestrictionType, PurchaseValueFrom, PurchaseValueTo, ProductGroupId, Creation, LastUpdate, ExternalId) VALUES (1, 1, 1, 'Discount 10%', 2, '2017-10-11 10:16:51.660', '2017-10-11 10:16:51.660', '', '', 10, 0, 0, 0, 0, 1, 0, 0, 0, '2017-10-11 10:17:26.463', '2017-10-11 10:17:54.820', '');
go
INSERT INTO DiscountDefined (DiscountDefinedId, IsActive, Type, Name, Purpose, DateFrom, DateTo, Days, Hours, DefaultValue, MaxValue, IsEditable, IsObligatory, IsPriceModify, RestrictionType, PurchaseValueFrom, PurchaseValueTo, ProductGroupId, Creation, LastUpdate, ExternalId) VALUES (2, 1, 1, 'Item discount 5%', 1, '2017-10-11 10:17:28.799', '2017-10-11 10:17:28.799', '', '', 5, 0, 0, 0, 0, 1, 0, 0, 0, '2017-10-11 10:17:52.241', '2017-10-11 10:17:52.241', '');
go