/*==============================================================*/
/* Skrypt wpisujący dane demo do bazy Bonownika SQLite          */
/*                                                              */
/*                                             wrzesień 2019    */
/*==============================================================*/

/* Informacja o tym, że baza nie jest pusta */
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'IsDatabaseEmpty', 0, '1', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'DatabaseType', 0, 'demo', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* PosGroup */
INSERT INTO PosGroup (PosGroupId, Name, IsActive, Creation, LastUpdate) VALUES (1, 'Liniowe', 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Pos */
INSERT INTO Pos (PosId, PosGroupId, type, Name, Number, IsActive, Creation, LastUpdate) VALUES (1, 1, 5, '1', 1, 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Pos (PosId, PosGroupId, type, Name, Number, IsActive, Creation, LastUpdate) VALUES (2, 1, 5, '0', 0, 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* OperatorProfile */
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (1, 0, '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (2, 1, '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (3, 2, '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO OperatorProfile (ProfileId, Type, Name, Creation, LastUpdate) VALUES (4, 3, '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Operator */
INSERT INTO Operator (OperatorId, ProfileId, IsActive, Number, FirstName, FamilyName, description, ExternalId, LoginName, IsOffLine, PrepaidUser, PrepaidPassword, Creation, LastUpdate, Password, IdCardCode)
VALUES (1, 4, 1, 1, '', 'Janko Serwisant', '', '', '999', 0, '', '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'), '091117074011173248090066', '999')
go
INSERT INTO Operator (OperatorId, ProfileId, IsActive, Number, FirstName, FamilyName, description, ExternalId, LoginName, IsOffLine, PrepaidUser, PrepaidPassword, Creation, LastUpdate, Password, IdCardCode)
VALUES (2, 1, 1, 1, '', 'Anna Kowalska', '', '', '1', 0, '', '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'), '104031214009050001174255', '1')
go
INSERT INTO Operator (OperatorId, ProfileId, IsActive, Number, FirstName, FamilyName, description, ExternalId, LoginName, IsOffLine, PrepaidUser, PrepaidPassword, Creation, LastUpdate, Password, IdCardCode)
VALUES (3, 1, 1, 1, '', 'Marcin Frykas', '', '', '2', 0, '', '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'), '128101157045016063123069', '2')
go

/* Product Group */
INSERT INTO ProductGroup VALUES(1,1,'Szef kuchni poleca',NULL,NULL,NULL,NULL,NULL,1,'2013-09-16 16:52:03.251','2013-09-16 16:52:03.252',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(2,1,'Zakąski zimne',NULL,NULL,NULL,NULL,NULL,2,'2013-09-16 16:52:03.469','2013-09-16 16:52:03.470',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(3,1,'Zakąski gorące',NULL,NULL,NULL,NULL,NULL,3,'2013-09-16 16:52:03.631','2013-09-16 16:52:03.631',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(4,1,'Sałaty',NULL,NULL,NULL,NULL,NULL,4,'2013-09-16 16:52:03.750','2013-09-16 16:52:03.750',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(5,1,'Zupy',NULL,NULL,NULL,NULL,NULL,5,'2013-09-16 16:52:03.886','2013-09-16 16:52:03.886',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(6,1,'Ryby',NULL,NULL,NULL,NULL,NULL,6,'2013-09-16 16:52:04.047','2013-09-16 16:52:04.047',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(7,1,'Dania główne',NULL,NULL,NULL,NULL,NULL,7,'2013-09-16 16:52:04.151','2013-09-16 16:52:04.151',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(8,1,'Desery',NULL,NULL,NULL,NULL,NULL,8,'2013-09-16 16:52:04.320','2013-09-16 16:52:04.320',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(9,1,'Dodatki',NULL,NULL,NULL,NULL,NULL,9,'2013-09-16 16:52:04.506','2013-09-16 16:52:04.506',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(10,1,'Napoje',NULL,NULL,NULL,NULL,NULL,10,'2013-09-16 16:52:04.658','2013-09-16 16:52:04.659',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(11,1,'Alkohol',NULL,NULL,NULL,NULL,NULL,11,'2013-09-16 16:52:04.794','2013-09-16 16:52:04.794',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(12,1,'Zestawy',NULL,NULL,NULL,NULL,NULL,12,'2013-12-20 12:04:10.083','2013-12-20 12:04:10.083',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(13,1,'Kawa',NULL,NULL,NULL,NULL,NULL,13,'2014-01-13 12:43:08.277','2014-01-13 12:43:08.277',NULL,0,0,0);
go
INSERT INTO ProductGroup VALUES(14,1,'Zimne napoje',NULL,NULL,NULL,NULL,NULL,14,'2014-01-13 12:43:08.316','2014-01-13 12:43:08.316',NULL,0,0,0);
go

/* ProductGroupTree */
INSERT INTO ProductGroupTree VALUES(10,13);
go
INSERT INTO ProductGroupTree VALUES(10,14);
go

/* VatRate */
INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (1, 1, 2300, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (2, 1, 800, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (3, 1, 500, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (4, 1, 0, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (5, 1, -1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

INSERT INTO VatRate (VatRateId, IsActive, Value, Creation, LastUpdate)
VALUES (6, 1, 100, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* UnitName */
INSERT INTO UnitName (UnitNameId, IsActive, Name, Precission, ExternalId, Creation, LastUpdate)
VALUES (1, 1, 'szt.', 0, '', strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Product */
INSERT INTO Product VALUES(1,1,1,1,NULL,1,NULL,'Krem brulee z drobiowych wątróbek','',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:10.303','2013-09-16 16:52:10.304',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(2,1,1,1,NULL,1,NULL,'Pieczona pierś kaczki Berbeyskiej','',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:13.433','2013-09-16 16:52:13.433',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(3,1,1,1,NULL,1,NULL,'Boeuf Strogonow','',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:52:16.043','2013-09-16 16:52:16.044',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(4,1,1,1,NULL,1,NULL,'Medaliony w polędwiczek wieprzowych','',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:20.181','2013-09-16 16:52:20.181',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(5,1,1,1,NULL,1,NULL,'Kotlet schabowy','',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:23.434','2013-09-16 16:52:23.434',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(6,1,1,1,NULL,1,NULL,'Wykwintna beza czekoladowo-daktylowa','',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:28.131','2013-09-16 16:52:28.131',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(7,1,2,1,NULL,1,NULL,'Wyborny pasztet z dziczyzny','',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:30.323','2013-09-16 16:52:30.324',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(8,1,2,1,NULL,1,NULL,'Łosoś z dębowej beczki (2 dni marynowany)','',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:33.006','2013-09-16 16:52:33.007',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(9,1,2,1,NULL,1,NULL,'Kremlowski tatar z łososia z kawiorem','',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:35.759','2013-09-16 16:52:35.759',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(10,1,2,1,NULL,1,NULL,'Tatar a''la Fidel Castro','',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:37.902','2013-09-16 16:52:37.902',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(11,1,2,1,NULL,1,NULL,'Deska frykasów PRL-u','',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:39.871','2013-09-16 16:52:39.871',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(12,1,2,1,NULL,1,NULL,'PRL – owski Smalec Luksusowy','',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:43.179','2013-09-16 16:52:43.180',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(13,1,2,1,NULL,1,NULL,'Zimne nóżki w galarecie – nasza specjalność!','',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:45.373','2013-09-16 16:52:45.373',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(14,1,2,1,NULL,1,NULL,'Dorodny eksportowy śledź bałtycki','',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:47.252','2013-09-16 16:52:47.253',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(15,1,3,1,NULL,1,NULL,'Kołduny Breżniewa','',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:49.746','2013-09-16 16:52:49.746',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(16,1,3,1,NULL,1,NULL,'Bliny Wołodii z łososiem i kawiorem','',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:52:51.985','2013-09-16 16:52:51.985',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(17,1,3,1,NULL,1,NULL,'Krewetki Naczelnego Oberżysty','',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:54.340','2013-09-16 16:52:54.341',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(18,1,3,1,NULL,1,NULL,'Piwna Deska Gustawa Husaka','',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:56.158','2013-09-16 16:52:56.158',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(19,1,3,1,NULL,1,NULL,'Chrupiące placki ziemniaczane','',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:52:58.064','2013-09-16 16:52:58.145',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(20,1,3,1,NULL,1,NULL,'Chrupiące placki ziemniaczane','',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:00.824','2013-09-16 16:53:00.841',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(21,1,3,1,NULL,1,NULL,'Pierogi naszego wyrobu','',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:03.255','2013-09-16 16:53:03.255',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(22,1,4,1,NULL,1,NULL,'Sałata Ogrodowa','',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:05.370','2013-09-16 16:53:05.370',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(23,1,4,1,NULL,1,NULL,'Luksusowa z kozim serem','',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:07.587','2013-09-16 16:53:07.587',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(24,1,4,1,NULL,1,NULL,'Bułgarska sałata Todora Żiwkowa','',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:09.471','2013-09-16 16:53:09.471',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(25,1,4,1,NULL,1,NULL,'Sałata Gomułki','',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:11.672','2013-09-16 16:53:11.672',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(26,1,4,1,NULL,1,NULL,'Sałata Szpionów KGB','',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:13.906','2013-09-16 16:53:13.907',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(27,1,5,1,NULL,1,NULL,'Gierkowa Truflowa','',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:53:15.775','2013-09-16 16:53:15.775',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(28,1,5,1,NULL,1,NULL,'Sztandarowy Żur','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:17.945','2013-09-16 16:53:17.945',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(29,1,5,1,NULL,1,NULL,'Flaki wołowe ,,po warszawsku”','',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:20.366','2013-09-16 16:53:20.366',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(30,1,5,1,NULL,1,NULL,'Rosół gospodyni domowej','',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:22.429','2013-09-16 16:53:22.430',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(31,1,5,1,NULL,1,NULL,'Czerwony barszcz z kołdunami','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:24.818','2013-09-16 16:53:24.818',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(32,1,5,1,NULL,1,NULL,'Pierwszomajowy barszcz czerwony (w kubku)','',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:26.618','2013-09-16 16:53:26.619',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(33,1,5,1,NULL,1,NULL,'Barszcz Przodownika Pracy','',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:53:28.994','2013-09-16 16:53:29.043',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(34,1,6,1,NULL,1,NULL,'Kapitalistyczny łosoś norweski','',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:30.960','2013-09-16 16:53:30.961',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(35,1,6,1,NULL,1,NULL,'Halibut Dygnitarski','',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:33.448','2013-09-16 16:53:33.449',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(36,1,6,1,NULL,1,NULL,'Sola „Pani Cyrankiewiczowej”','',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:35.826','2013-09-16 16:53:35.827',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(37,1,7,1,NULL,1,NULL,'Kaczka po polsku a’la Czerwony Wieprz','',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:37.990','2013-09-16 16:53:37.990',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(38,1,7,1,NULL,1,NULL,'Polędwiczki wieprzowe I-go Sekretarza','',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:40.666','2013-09-16 16:53:40.666',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(39,1,7,1,NULL,1,NULL,'Grillowane kotleciki jagnięce z kozim serem','',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:42.464','2013-09-16 16:53:42.464',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(40,1,7,1,NULL,1,NULL,'Golonka Ericha – nasz specjał!','',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:53:45.117','2013-09-16 16:53:45.117',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(41,1,7,1,NULL,1,NULL,'Kurczak Mao','',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:47.623','2013-09-16 16:53:47.623',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(42,1,7,1,NULL,1,NULL,'Zrazy z dzika a’la Marszałek Tito','',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:50.853','2013-09-16 16:53:50.853',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(43,1,7,1,NULL,1,NULL,'Żebra CZERWONEGO WIEPRZA – dla 2 osób','',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-09-16 16:53:53.072','2013-09-16 16:53:53.072',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(44,1,7,1,NULL,1,NULL,'Polędwica LIMOUSINE a’la Książe Karpat','',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:55.056','2013-09-16 16:53:55.056',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(45,1,7,1,NULL,1,NULL,'Pyzy z „Różyka”','',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:57.024','2013-09-16 16:53:57.024',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(46,1,7,1,NULL,1,NULL,'Kotlet De Volaille a’la Czerwony Wieprz','',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:53:59.854','2013-09-16 16:53:59.854',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(47,1,7,1,NULL,1,NULL,'Węgierski placek Kadara','',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:02.014','2013-09-16 16:54:02.085',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(48,1,8,1,NULL,1,NULL,'Czekoladowy torcik Cartera','',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:04.827','2013-09-16 16:54:04.827',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(49,1,8,1,NULL,1,NULL,'Creme Brulée a’la Czerwony Wieprz','',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:07.168','2013-09-16 16:54:07.168',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(50,1,8,1,NULL,1,NULL,'Gwiazda Fidela - specjalność naszej Cukierni','',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:09.678','2013-09-16 16:54:09.678',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(51,1,8,1,NULL,1,NULL,'Torcik „Black&White”','',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:12.119','2013-09-16 16:54:12.119',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(52,1,8,1,NULL,1,NULL,'Gorące śliwki „badylarza” z lodami waniliowymi','',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:13.708','2013-09-16 16:54:13.708',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(53,1,8,1,NULL,1,NULL,'Sernik Tradycyjny','',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:16.351','2013-09-16 16:54:16.351',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(54,1,8,1,NULL,1,NULL,'Domowa szarlotka z lodami','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:18.462','2013-09-16 16:54:18.462',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(55,1,9,1,NULL,1,NULL,'Ziemniaki po polsku','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:20.860','2013-09-16 16:54:20.860',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(56,1,9,1,NULL,1,NULL,'Ziemniaki z wody','',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:22.291','2013-09-16 16:54:22.291',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(57,1,9,1,NULL,1,NULL,'Ziemniaki tłuczone','',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:24.393','2013-09-16 16:54:24.394',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(58,1,9,1,NULL,1,NULL,'Frytki','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:25.502','2013-09-16 16:54:25.502',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(59,1,9,1,NULL,1,NULL,'Kopytka własnego wyrobu','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:26.488','2013-09-16 16:54:26.488',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(60,1,9,1,NULL,1,NULL,'Kasza gryczana','',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:29.932','2013-09-16 16:54:29.932',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(61,1,9,1,NULL,1,NULL,'Ryż biały','',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:30.906','2013-09-16 16:54:30.906',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(62,1,9,1,NULL,1,NULL,'Fasolka szparagowa','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:32.332','2013-09-16 16:54:32.332',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(63,1,9,1,NULL,1,NULL,'Bukiet warzyw na parze','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:33.119','2013-09-16 16:54:33.119',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(64,1,9,1,NULL,1,NULL,'Kapusta z grochem','',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:34.040','2013-09-16 16:54:34.040',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(65,1,9,1,NULL,1,NULL,'Buraczki zasmażane','',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:35.651','2013-09-16 16:54:35.651',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(66,1,9,1,NULL,1,NULL,'Sosy gorące i zimne','',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:36.779','2013-09-16 16:54:36.780',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(67,1,14,1,NULL,1,NULL,'Coca Cola','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:37.658','2013-09-16 16:54:37.658',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(68,1,14,1,NULL,1,NULL,'Coca Cola Zero','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:38.624','2013-09-16 16:54:38.624',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(69,1,14,1,NULL,1,NULL,'Coca Cola Light','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:39.396','2013-09-16 16:54:39.396',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(70,1,14,1,NULL,1,NULL,'Fanta','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:40.288','2013-09-16 16:54:40.288',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(71,1,14,1,NULL,1,NULL,'Sprite','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:41.344','2013-09-16 16:54:41.344',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(72,1,14,1,NULL,1,NULL,'Kinley Tonic','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:41.974','2013-09-16 16:54:41.974',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(73,1,10,1,NULL,1,NULL,'Woda Kropla Beskidu','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:43.511','2013-09-16 16:54:43.511',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(74,1,10,1,NULL,1,NULL,'Woda Kropla Beskidu','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:45.888','2013-09-16 16:54:45.889',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(75,1,10,1,NULL,1,NULL,'Woda S. Pellegrino','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:46.776','2013-09-16 16:54:46.776',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(76,1,14,1,NULL,1,NULL,'Soki owocowe Cappy','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:47.565','2013-09-16 16:54:47.635',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(77,1,10,1,NULL,1,NULL,'Soki wyciskane ze świeżych owoców','',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:48.550','2013-09-16 16:54:48.550',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(78,1,14,1,NULL,1,NULL,'Nestea','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:50.700','2013-09-16 16:54:50.700',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(79,1,14,1,NULL,1,NULL,'Nestea','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:53.638','2013-09-16 16:54:53.638',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(80,1,14,1,NULL,5,NULL,'Burn','',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:54.502','2013-09-16 16:54:54.502',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(81,1,14,1,NULL,1,NULL,'Red bull','',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:55.424','2013-09-16 16:54:55.424',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(82,1,10,1,NULL,1,NULL,'Herbata Ronnefeldt Leaf Cup','',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:56.889','2013-09-16 16:54:56.889',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(83,1,13,1,NULL,1,NULL,'Espresso','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:58.028','2013-09-16 16:54:58.029',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(84,1,13,1,NULL,1,NULL,'Podwójne espresso','',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:54:59.357','2013-09-16 16:54:59.357',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(85,1,13,1,NULL,1,NULL,'Kawa','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:01.499','2013-09-16 16:55:01.499',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(86,1,13,1,NULL,1,NULL,'Duża kawa','',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:03.653','2013-09-16 16:55:03.653',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(87,1,13,1,NULL,1,NULL,'Cappuccino','',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:05.044','2013-09-16 16:55:05.045',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(88,1,13,1,NULL,1,NULL,'Latte','',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:06.593','2013-09-16 16:55:06.593',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(89,1,13,1,NULL,1,NULL,'Proletariacka mielona, zalewana','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:07.443','2013-09-16 16:55:07.443',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(90,1,11,1,NULL,1,NULL,'0.3l Żywiec','',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:08.541','2013-09-16 16:55:08.541',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(91,1,11,1,NULL,1,NULL,'0.5l Żywiec','',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:09.456','2013-09-16 16:55:09.457',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(92,1,11,1,NULL,1,NULL,'1l Żywiec','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:10.448','2013-09-16 16:55:10.448',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(93,1,11,1,NULL,1,NULL,'5l "Budka z piwem"','',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:12.766','2013-09-16 16:55:12.766',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(94,1,11,1,NULL,1,NULL,'0,25l Guinness','',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:14.053','2013-09-16 16:55:14.053',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(95,1,11,1,NULL,1,NULL,'0,5l Guinness','',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:15.051','2013-09-16 16:55:15.051',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(96,1,11,1,NULL,1,NULL,'Wódka 40g Sobieski','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:15.928','2013-09-16 16:55:15.928',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(97,1,11,1,NULL,1,NULL,'Wódka 40g Żytnia','',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:17.438','2013-09-16 16:55:17.438',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(98,1,11,1,NULL,1,NULL,'Wódka 40g Danzka','',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,'',NULL,'2013-09-16 16:55:19.489','2013-09-16 16:55:19.489',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(102,1,12,1,NULL,1,NULL,'Danie dnia - poniedziałek','',0,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-12-20 12:06:37.391','2013-12-20 12:06:37.391',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(103,1,12,1,NULL,1,NULL,'Szarlotka i napój w super cenie!','',0,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-12-20 12:06:39.523','2013-12-20 12:06:39.525',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go
INSERT INTO Product VALUES(104,1,12,1,NULL,1,NULL,'Żebra z piwem zawsze taniej!','',0,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,1,'1',NULL,'2013-12-20 12:06:41.189','2013-12-20 12:06:41.210',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,0,'');
go

/* Barcode */
INSERT INTO Barcode VALUES(1,1,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(2,2,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(3,3,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(4,4,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(5,5,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(6,6,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(7,7,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(8,8,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(9,9,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(10,10,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(11,11,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(12,12,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(13,13,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(14,14,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(15,15,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(16,16,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(17,17,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(18,18,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(19,19,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(20,20,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(21,21,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(22,22,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(23,23,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(24,24,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(25,25,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(26,26,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(27,27,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(28,28,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(29,29,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(30,30,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(31,31,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(32,32,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(32,33,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(33,34,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(34,35,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(35,36,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(36,37,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(37,38,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(38,39,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(39,40,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(40,41,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(41,42,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(42,43,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(43,44,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(44,45,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(45,46,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(46,47,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(47,48,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(48,49,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(49,50,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(50,51,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(51,52,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(52,53,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(53,54,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(54,55,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(55,56,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(56,57,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(57,58,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(58,59,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(59,60,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(60,61,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(61,62,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(62,63,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(63,64,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(64,65,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(65,66,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(66,67,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(67,68,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(68,69,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(69,70,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(70,71,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(71,72,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(72,73,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(73,74,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(74,75,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(75,76,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(76,77,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(77,78,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(78,79,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(79,80,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(80,81,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(81,82,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(82,83,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(83,84,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(84,85,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(85,86,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(86,87,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(87,88,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(88,89,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(89,90,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(90,91,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(91,92,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(92,93,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(93,94,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(94,95,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(95,96,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(96,97,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(97,98,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(1001,102,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(1002,103,1,1,'',1,0,'');
go
INSERT INTO Barcode VALUES(1003,104,1,1,'',1,0,'');
go


/* ProductDescription */
/*
INSERT INTO ProductDescription (ProductId, DescType, Ordinal, Description)
VALUES (1, 0, 0, 'Doprawiony Porto, podawany z konfiturą z czerwonej cebuli i chrupiącym chlebem')
go
*/
INSERT INTO ProductDescription VALUES(1,0,0,'Doprawiony Porto, podawany z konfiturą z czerwonej cebuli i chrupiącym chlebem.');
go
INSERT INTO ProductDescription VALUES(2,0,0,'Serwowana w towarzystwie duszonych śliwek i gruszek marynowanych w czerwonym winie.');
go
INSERT INTO ProductDescription VALUES(3,0,0,'Podany klasycznie z najlepszej polskiej polędwicy wołowej, duszonej w pomidorach, cebuli i grzybach, podawany z chrupiącym chlebem naszego wypieku.');
go
INSERT INTO ProductDescription VALUES(3,2,0,'Opis2');
go
INSERT INTO ProductDescription VALUES(3,3,0,'Opis 3');
go
INSERT INTO ProductDescription VALUES(3,4,0,'Opis 4');
go
INSERT INTO ProductDescription VALUES(3,5,0,'Opis 5');
go
INSERT INTO ProductDescription VALUES(3,7,0,'wołowy|wieprzowy|kurczakowy|pieprzowy z kminkiem|limonkowy z cebulką');
go
INSERT INTO ProductDescription VALUES(4,0,0,'Okraszone rumianą cebulą i pieczarkami.');
go
INSERT INTO ProductDescription VALUES(5,0,0,'Tradycyjny, podany z domową mizerią.');
go
INSERT INTO ProductDescription VALUES(6,0,0,'Podawana w karmelowym sosie z Irish Whiskey.');
go
INSERT INTO ProductDescription VALUES(7,0,0,'pieczony w otoczce z wędzonego boczku, przyprawiany jałowcem i rozmarynem, podawany z marynatami i leśną żurawiną');
go
INSERT INTO ProductDescription VALUES(8,0,0,'podawany na chrupiącej sałacie z delikatnym soisem miodowo-cytrybowym, z koprem ogrodowym, krążkami cebuli i zielonym pieprzem');
go
INSERT INTO ProductDescription VALUES(9,0,0,'przyrządzany z łososia bałtyckiego, ze świeżymi ogórkami i koprem, podawany z kwaśna śmietaną i rosyjskim czerwonym kawiorem');
go
INSERT INTO ProductDescription VALUES(10,0,0,'siekany filet z Soli Atlantyckiej z avocado i grillowanymi krewetkami podawany z kolendrowym vinaigrette');
go
INSERT INTO ProductDescription VALUES(11,0,0,'- specjały naszego wyrobu (dla 2 Osób). Codziennie pieczone: rozbef, schab, karczek, pasztet z dziczyzny, i rolada z boczku oraz kiełbasa sucha jałowcowa, podwędzana pasztetowa, sos tatarski, tarty chrzan, musztarda, marynaty');
go
INSERT INTO ProductDescription VALUES(12,0,0,'z kiełbasą myśliwską, skwarkami, jabłkiem i cebulą, podawany z chlebem i kwaszonym ogórkiem');
go
INSERT INTO ProductDescription VALUES(13,0,0,'podawane z marynowanymi kurkami, podgrzybkami i octem kurkowym (przyrządzane wg. oryginalnej receptury z Baru Mlecznego „Magda”, który funkcjonował w tym miejscu w latach 70-tych.)');
go
INSERT INTO ProductDescription VALUES(14,0,0,'w oleju, z siekaną cebulą i pieczonym ziemniakiem lub w śmietanie, z tartym jabłkiem, porem i pieczonym ziemniakiem');
go
INSERT INTO ProductDescription VALUES(15,0,0,'nadziewane pikantną baraniną i czosnkiem, doprawiane majerankiem i podawane w klarowanym maśle');
go
INSERT INTO ProductDescription VALUES(16,0,0,'chrupiące racuchy gryczane podawane z różyczkami z wędzonego łososia, kwaśną śmietaną i czerwonym rosyjskim kawiorem (ulubiona zakąska Włodzimierza Iljicza Lenina, przyrządzana wg. przepisu Nadieżdy Krupskiej)');
go
INSERT INTO ProductDescription VALUES(17,0,0,'podawane na gorącej patelni, w sosie z białego wina, z dodatkiem czosnku, papryki i pikantnej czuszki, z chrupiącą grzanką');
go
INSERT INTO ProductDescription VALUES(18,0,0,'- dla 2 osób. Zestaw zakąsek piwnych ( grillowane polędwiczki kurczaka, panierowany ser konecki, krążki cebulowe, chrupiący boczek i pieczone kabanosy), podawane z sosem czosnkowym i pikantnym z pomidorów i siekanych warzyw');
go
INSERT INTO ProductDescription VALUES(19,0,0,'z kwaśną śmietaną');
go
INSERT INTO ProductDescription VALUES(20,0,0,'z sosem grzybowym');
go
INSERT INTO ProductDescription VALUES(21,0,0,'ze szpinakiem, fetą i czosnkiem, lub z kapustą i grzybami leśnymi, lub z mięsem, lub ruskie');
go
INSERT INTO ProductDescription VALUES(22,0,0,'z mieszanych warzyw sezonowych z miodowo-cytrynowym vinaigrette');
go
INSERT INTO ProductDescription VALUES(23,0,0,'kremowy kozi ser na chrupiących faworkach, z suszonymi na słońcu pomidorami i delikatnie pikantnym dressingiem z dodatkiem czosnku i papryczek piri-piri, podawany na mieszanych sałatach');
go
INSERT INTO ProductDescription VALUES(24,0,0,'grillowane warzywa ogrodowe marynowane w oliwie, czosnku i zielonej pietruszce, podawane z sosem ze świeżych ziół i razowymi grzankami zapiekanymi pod kozim serem');
go
INSERT INTO ProductDescription VALUES(25,0,0,'rumiane wątróbki z patelni podawane na chrupiących sałatach, z serem Brie i malinowym vinaigrette');
go
INSERT INTO ProductDescription VALUES(26,0,0,'bukiet sałat z grillowanymi polędwiczkami kurczaka, kremowym sosem ziołowo-musztardowym, płatkami Grana Padano i chrupiącą grzanką');
go
INSERT INTO ProductDescription VALUES(27,0,0,'delikatny krem truflowy, z pieczonym kurczakiem, płatkami Grana Padano i grzankami oliwkowo-truflowymi. Ulubiona zupa Towarzysza Edwarda, której recepturę pozyskał od żony Generała De Goulla w trakcie jednej z francuskich podróży');
go
INSERT INTO ProductDescription VALUES(28,0,0,'na prawdziwkach i wiejskiej wędzonce, z jajem i białą kiełbasą, doprawiany tartym chrzanem i majerankiem');
go
INSERT INTO ProductDescription VALUES(29,0,0,'przyrządzane w tradycyjnym, staro-warszawskim stylu, podawane z grzanką zapiekaną pod żółtym serem');
go
INSERT INTO ProductDescription VALUES(30,0,0,'warzony na wiejskiej kurze i warzywach, z ręcznie wyrabianym makaronem');
go
INSERT INTO ProductDescription VALUES(31,0,0,'aromatyczny wywar z buraków, warzony na tradycyjnym zakwasie, z suszonymi podgrzybkami i jabłkiem „Antonówka”, doprawiony nutą malinowego octu, podawany z kołdunami nadziewanymi baraniną i czosnkiem');
go
INSERT INTO ProductDescription VALUES(32,0,0,'doskonały do pierogów!');
go
INSERT INTO ProductDescription VALUES(33,0,0,'barszcz czerwony zabielany kwaśną śmietaną, podawany z tłuczonymi ziemniakami i chrupiącymi skwarkami');
go
INSERT INTO ProductDescription VALUES(34,0,0,'marynowany w cytrynie i czosnku filet z łososia, zapiekany w piecu pod kruszonką z ziół i zielonego pieprzu');
go
INSERT INTO ProductDescription VALUES(35,0,0,'soczysty halibut z patelni, smażony na klarowanym maśle, podawany z sosem z białego wina i blanszowanych porów');
go
INSERT INTO ProductDescription VALUES(36,0,0,'pieczony w pergaminie delikatny filet z Soli, nadziewany warzywami, podawany w towarzystwie kremowego sosu rakowego i pomidora zapiekanego pod Parmezanem (receptura otrzymana od Pani Niny Andrycz – legendy warszawskiego teatru i żony PRL-owskiego Premiera');
go
INSERT INTO ProductDescription VALUES(36,0,1,'Józefa Cyrankiewicza)');
go
INSERT INTO ProductDescription VALUES(37,0,0,'Specjalność Szefa Kuchni! Pół kaczki berberyjskiej, leżakowanej w morskiej soli z czosnkiem i majerankiem, serwowane z sosem z polskich wiśni, pieczonym jabłkiem i buraczkami. Wielokrotna medalistka konkursu o Złotą Patelnię!');
go
INSERT INTO ProductDescription VALUES(38,0,0,'grillowane na ruszcie polędwiczki wieprzowe, zapiekane w piecu z cukinią, prażonymi pestkami dyni i serem feta, w kremowym sosie ze świeżej bazylii');
go
INSERT INTO ProductDescription VALUES(39,0,0,'z siekanej jagnięciny podhalańskiej, z czosnkiem, ziołami i sosem jogurtowo-miętowym, z dodatkiem jabłek prażonych na klarowanym maśle');
go
INSERT INTO ProductDescription VALUES(40,0,0,'pieczona w piecu, w bawarskim sosie karmelowo-piwnym, podawana z pure z grochu, przyrządzana wg. staroenerdowskiego przepisu odziedziczonego przez Ericha Honeckera po jego babci Gertrudzie');
go
INSERT INTO ProductDescription VALUES(41,0,0,'kurczak w chińskim stylu, w chrupiącym cieście, z aromatycznym sosem korzenno-pomarańczowym.
(ulubione danie żony Mao Tse-Tunga, które serwował jego kucharz w trakcie historycznej biesiady w Czerwonym Wieprzu)');
go
INSERT INTO ProductDescription VALUES(42,0,0,'Polędwica z dzika marynowana w jałowcu i trawie żubrowej, nadziewana grzybami, boczkiem i gorczycą , podawana w sosie z leśnych grzybów. (popisowe danie Marszałka Josipa Broz Tito, które osobiście przyrządzał po słynnych polowaniach w Puszczy Białowieskie');
go
INSERT INTO ProductDescription VALUES(42,0,1,'j, gdzie do dziś stoi jego szałas myśliwski zwany „titówką”)');
go
INSERT INTO ProductDescription VALUES(43,0,0,'zacna porcja marynowanych w beczce i pieczonych w piecu żeber, podawana na drewnianej desce, z ziemniakami zasmażanymi z czosnkiem, majerankiem i rozmarynem oraz zestawem sosów');
go
INSERT INTO ProductDescription VALUES(44,0,0,'soczysty stek z wykwintnej polędwicy wołowej „Limousine” na sosie koniakowo-pieprzowym, podlewanym oryginalną rumuńską brandy (ulubione danie Nicolae Ceausescu)');
go
INSERT INTO ProductDescription VALUES(45,0,0,'nadziewane mięsem i okraszane skwarkami, podawane ze smażonymi kartaczami (słynny przebój kulinarny kultowego warszawskiego Bazaru Różyckiego)');
go
INSERT INTO ProductDescription VALUES(46,0,0,'zawijana pierś z kurczaka, nadziewana pieczarkami, siekaną pietruszką, masłem i serem Mimolette');
go
INSERT INTO ProductDescription VALUES(47,0,0,'chrupiący placek ziemniaczany serwowany z pikantnym gulaszem wołowym podlewanym winem Tokaj');
go
INSERT INTO ProductDescription VALUES(48,0,0,'listki wykwintnej belgijskiej czekolady przekładane aksamitnym kremem czekoladowym, podawane na pomarańczowym sosie z likierem Cointreau (deser, którym podejmowany był Prezydent USA Jimmy Carter podczas uroczystej kolacji na jego cześć, w trakcie wizyty w');
go
INSERT INTO ProductDescription VALUES(48,0,1,'PRL w 1977r)');
go
INSERT INTO ProductDescription VALUES(49,0,0,'przyrządzany przez naszego Cukiernika wg oryginalnej francuskiej receptury, podawany w towarzystwie sezonowych owoców');
go
INSERT INTO ProductDescription VALUES(50,0,0,'ulubiony deser Fidela Castro - pieczona w ceramicznym piecu beza migdałowa wypełniona aksamitnym kremem waniliowo-migdałowym, aromatyzowanym nutą kubańskiego rumu Havana Club, wyrabiana na bazie syropu trzcinowego i prażonych migdałów, podawana na czerwon');
go
INSERT INTO ProductDescription VALUES(50,0,1,'ej gwieździe.');
go
INSERT INTO ProductDescription VALUES(51,0,0,'duet musów z białej i ciemnej belgijskiej czekolady, podawany z gałką prawdziwych lodów waniliowych i konfiturą z leśnych jagód');
go
INSERT INTO ProductDescription VALUES(52,0,0,'PRL-owski przysmak wymyślony przez grójeckich plantatorów śliwek. Swą niewysublimowaną prostotą zaskakuje do dziś!');
go
INSERT INTO ProductDescription VALUES(53,0,0,'pieczony w ceramicznym piecu, wyrabiany przez naszego cukiernika z białego wiejskiego sera i bitej śmietany, z dodatkiem rodzynek i suszonej skórki pomarańczy');
go
INSERT INTO ProductDescription VALUES(54,0,0,'wypiekana z jabłek ogrodowych z dodatkiem soczystych brzoskwiń, podawana z kremowymi lodami waniliowymi');
go
INSERT INTO ProductDescription VALUES(55,0,0,'zasmażane z czosnkiem, majerankiem i cebulą');
go
INSERT INTO ProductDescription VALUES(57,0,0,'ze skwarkami');
go
INSERT INTO ProductDescription VALUES(73,0,0,'niegazowana');
go
INSERT INTO ProductDescription VALUES(74,0,0,'gazowana');
go
INSERT INTO ProductDescription VALUES(78,0,0,'cytrynowa');
go
INSERT INTO ProductDescription VALUES(79,0,0,'brzoskwiniowa');
go
INSERT INTO ProductDescription VALUES(86,0,0,'na podwójnym espresso');
go
INSERT INTO ProductDescription VALUES(93,0,0,'czyli tuba Żywca kufel piwa gratis!');
go


/* GastroElement */
INSERT INTO GastroElement VALUES(102,0,2,'Danie główne',0,1,1,0);
go
INSERT INTO GastroElement VALUES(102,1,3,'Sałatka',0,1,1,1);
go
INSERT INTO GastroElement VALUES(102,2,1,'Dodatki',0,1,1,2);
go
INSERT INTO GastroElement VALUES(102,3,0,'Napój',0,1,1,3);
go
INSERT INTO GastroElement VALUES(103,0,2,'Szarlotka',0,1,1,0);
go
INSERT INTO GastroElement VALUES(103,1,2,'Napój',1.99,1,0,1);
go
INSERT INTO GastroElement VALUES(104,0,2,'Żebra',0,1,1,0);
go
INSERT INTO GastroElement VALUES(104,1,0,'Piwo',0,1,1,1);
go

/* GastroElementList */
INSERT INTO GastroElementList VALUES(102,0,0,16,36,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,0,1,40,37,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,1,0,24,27,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,1,1,23,33,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,1,2,25,28,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,1,3,22,17,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,1,4,26,29,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,2,0,65,7,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,2,1,58,8,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,2,2,55,8,1,1,0);
go
INSERT INTO GastroElementList VALUES(102,2,3,57,7,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,2,4,56,6,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,2,5,61,6,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,3,0,67,8,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,3,1,82,10,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,3,2,85,9,1,0,0);
go
INSERT INTO GastroElementList VALUES(102,3,3,73,8,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,0,0,54,15,1,1,0);
go
INSERT INTO GastroElementList VALUES(103,1,0,87,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,1,67,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,2,69,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,3,68,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,4,70,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,5,78,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(103,1,6,82,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,0,0,43,39,1,1,0);
go
INSERT INTO GastroElementList VALUES(104,1,0,94,11.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,1,1,95,15.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,1,2,90,4.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,1,3,91,7.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,1,4,92,15.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(104,1,5,93,69.9,1,0,0);
go
