/*==============================================================*/
/* Upgrade struktury tabeli Receipt do klucza podwójnego jak w  */
/* POSPremium oraz bez AUTOINCREMENT.                           */
/* Dodatkowa tablica do pilnowania zleceń kuchennych.           */
/*==============================================================*/
DROP TABLE Receipt
GO

CREATE TABLE Receipt (
   PosId                numeric(9)           not null,
   ReceiptId            INTEGER              not null,
   OperatorId           numeric(9)           null,
   ShiftId              numeric(9)           null,
   CustomerId           numeric(9)           null,
   TaxPayerId           numeric(9)           null,
   StoreId              numeric(9)           null,
   IsActive             smallint             not null,
   IsOffline            smallint             null,
   Type                 int                  not null,
   ExtType              int                  default 0 null,
   VatMarkup            int                  default 0 null,
   DocCounter           int                  null,
   DocNr                text(60)             null,
   OperationDate        datetime             not null,
   CustomerCard         text(20)             null,
   CustomerId2Type      int                  null,
   CustomerId2          text(20)             null,
   PostalCode           text(10)             null,
   TotalBrutto          decimal(14,2)        null,
   TotalNetto           decimal(14,2)        null,
   TotalDiscount        decimal(14,2)        null,
   DepositSold          decimal(14,2)        null,
   DepositReturned      decimal(14,2)        null,
   TotalPrepaid         decimal(14,2)        null,
   TotalBill            decimal(14,2)        null,
   TotalToPay           decimal(14,2)        null,
   PrinterStatus        smallint             not null,
   PrinterNumber        int                  null,
   PrinterReportNumber  int                  null,
   PrintoutNumber       int                  null,
   ValueDiscount        decimal(14,2)        null,
   IsPending            smallint             null,
   PendingOwner         text(10)             null,
   DiscountRoundupMethod smallint            null,
   DocumentSource       smallint             null,
   PriceLevel           smallint             null,
   ExternalId           text(20)             null,
   Creation             datetime             not null,
   LastUpdate           datetime             not null,
   constraint PK_RECEIPT primary key (ReceiptId, PosId)
)
GO
