/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.encoding.ContentType;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

public class StringDataContentHandler
implements DataContentHandler {
    private static final ActivationDataFlavor myDF = new ActivationDataFlavor(String.class, "text/plain", "Text String");

    protected ActivationDataFlavor getDF() {
        return myDF;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.getDF()};
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (this.getDF().equals(dataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        InputStreamReader inputStreamReader;
        String string = null;
        try {
            string = this.getCharset(dataSource.getContentType());
            inputStreamReader = new InputStreamReader(dataSource.getInputStream(), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
        try {
            int n;
            int n2 = 0;
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray, n2, cArray.length - n2)) != -1) {
                if ((n2 += n) < cArray.length) continue;
                int n3 = cArray.length;
                n3 = n3 < 262144 ? (n3 += n3) : (n3 += 262144);
                char[] cArray2 = new char[n3];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
            }
            String string2 = new String(cArray, 0, n2);
            return string2;
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter;
        if (!(object instanceof String)) {
            throw new IOException("\"" + this.getDF().getMimeType() + "\" DataContentHandler requires String object, was given object of type " + object.getClass().toString());
        }
        String string2 = null;
        try {
            string2 = this.getCharset(string);
            outputStreamWriter = new OutputStreamWriter(outputStream, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string2);
        }
        String string3 = (String)object;
        outputStreamWriter.write(string3, 0, string3.length());
        outputStreamWriter.flush();
    }

    private String getCharset(String string) {
        try {
            ContentType contentType = new ContentType(string);
            String string2 = contentType.getParameter("charset");
            if (string2 == null) {
                string2 = "us-ascii";
            }
            return Charset.forName(string2).name();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

